% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pagePlotRemove.R
\name{pagePlotRemove}
\alias{pagePlotRemove}
\title{Remove plotgardener plots and annotations}
\usage{
pagePlotRemove(plot)
}
\arguments{
\item{plot}{Plot object to be removed, defined by the output
of a plotgardener plotting function.}
}
\value{
None.
}
\description{
Remove plotgardener plots and annotations
}
\examples{
## Load Hi-C data
library(plotgardenerData)
data("IMR90_HiC_10kb")

## Create page
pageCreate(width = 5.5, height = 4, default.units = "inches")

## Plot and place a square Hi-C plot
hicPlot <- plotHicSquare(
    data = IMR90_HiC_10kb, resolution = 10000,
    zrange = c(0, 70),
    chrom = "chr21",
    chromstart = 28000000, chromend = 30300000,
    x = 0.5, y = 0.5, width = 2.5, height = 2.5,
    just = c("left", "top"),
    default.units = "inches"
)

## Remove square Hi-C plot from page
pagePlotRemove(plot = hicPlot)
}
