% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpatialMetrics.R
\name{CHAOS}
\alias{CHAOS}
\title{Calculate CHAOS score}
\usage{
CHAOS(labels, location, BNPARAM = NULL)
}
\arguments{
\item{labels}{Cluster labels.}

\item{location}{A numeric data matrix containing location information, where
rows are points and columns are location dimensions.}

\item{BNPARAM}{BNPARAM object passed to \code{\link[BiocNeighbors]{findKNN}}
specifying the kNN approximation method to use. Defaults to exact for small
datasets, and Annoy for larger ones.}
}
\value{
A numeric value for CHAOS score.
}
\description{
CHAOS score measures the clustering performance by calculating
the mean length of the graph edges in the 1-nearest neighbor (1NN) graph
for each cluster, averaged across clusters.
Lower CHAOS score indicates better spatial domain clustering performance.
}
\examples{
data(sp_toys)
data <- sp_toys
CHAOS(data$label, data[,c("x", "y")])
CHAOS(data$p1, data[,c("x", "y")])
CHAOS(data$p2, data[,c("x", "y")])
}
