% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPartitionGlobalMetrics.R
\name{getPartitionGlobalMetrics}
\alias{getPartitionGlobalMetrics}
\title{getPartitionGlobalMetrics}
\usage{
getPartitionGlobalMetrics(
  true,
  pred,
  metrics = c("RI", "WC", "WH", "ARI", "NCR", "AWC", "AWH", "MI", "AMI", "VI", "EH",
    "EC", "VM", "FM"),
  ...
)
}
\arguments{
\item{true}{A vector containing the labels of the true classes. Must be a
vector of characters, integers, numerics, or a factor, but not a list.}

\item{pred}{A vector containing the labels of the predicted clusters. Must
be a vector of characters, integers, numerics, or a factor, but not a list.}

\item{metrics}{The metrics to compute. If omitted, main metrics will be
computed. See below for more details.}

\item{...}{Optional arguments for MI, VI, or VM. See \code{\link[clevr:mutual_info]{clevr::mutual_info()}},
\code{\link[clevr:variation_info]{clevr::variation_info()}}
and \code{\link[clevr:v_measure]{clevr::v_measure()}} for more details.}
}
\value{
A dataframe of metric results. Possible metrics are:
\item{RI}{Rand Index}
\item{WC}{Wallace Completeness}
\item{WH}{Wallace Homogeneity}
\item{ARI}{Adjusted Rand Index}
\item{AWC}{Adjusted Wallace Completeness}
\item{AWH}{Adjusted Wallace Homogeneity}
\item{NCR}{Normalized class size Rand index}
\item{MI}{Mutual Information}
\item{AMI}{Adjusted Mutual Information}
\item{VI}{Variation of Information}
\item{EH}{(Entropy-based) Homogeneity}
\item{EC}{(Entropy-based) Completeness}
\item{VM}{V-measure}
\item{FM}{F-measure/weighted average F1 score}
\item{VDM}{Van Dongen Measure}
\item{MHM}{Meila-Heckerman Measure}
\item{MMM}{Maximum-Match Measure}
\item{Mirkin}{Mirkin Metric}
\item{Accuracy}{Set Matching Accuracy}
}
\description{
Computes a selection of external evaluation metrics for partition. The
metrics are reported per dataset.
}
\keyword{internal}
