% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proActiv.R
\name{integrateProactiv}
\alias{integrateProactiv}
\title{Integrate multiple proActiv runs}
\usage{
integrateProactiv(res1, res2, ..., promoterAnnotation, renormalize = TRUE)
}
\arguments{
\item{res1}{A summarizedExperiment object returned by proActiv}

\item{res2}{A summarizedExperiment object returned by proActiv}

\item{...}{Additional summarizedExperiment objects returned by proActiv}

\item{promoterAnnotation}{Promoter annotation object used to create 
proActiv runs}

\item{renormalize}{Whether to renormalize counts after merging. Defaults to 
TRUE}
}
\value{
A SummarizedExperiment object with assays giving promoter counts 
  and activity with gene expression. rowData contains
  promoter metadata and absolute promoter activity summarized across
  conditions (if condition is provided)
}
\description{
Integrate multiple proActiv runs
}
\examples{
f1 <- list.files(system.file('extdata/vignette/junctions', 
                             package = 'proActiv'), 
                 full.names = TRUE, pattern = 'A549')
f2 <- list.files(system.file('extdata/vignette/junctions', 
                             package = 'proActiv'), 
                 full.names = TRUE, pattern = 'HepG2')
promoterAnnotation <- promoterAnnotation.gencode.v34.subset
res1 <- proActiv(files = f1, promoterAnnotation  = promoterAnnotation,
                 condition = rep('A549',3))
res2 <- proActiv(files = f2, promoterAnnotation = promoterAnnotation,
                 condition = rep('HepG2',3))
res <- integrateProactiv(res1, res2, promoterAnnotation = promoterAnnotation)

}
