% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_synthetic_data.R
\name{generate_synthetic_data}
\alias{generate_synthetic_data}
\title{Generate a dataset according to the probabilistic dropout model}
\usage{
generate_synthetic_data(
  n_proteins,
  n_conditions = 2,
  n_replicates = 3,
  frac_changed = 0.1,
  dropout_curve_position = 18.5,
  dropout_curve_scale = -1.2,
  location_prior_mean = 20,
  location_prior_scale = 4,
  variance_prior_scale = 0.05,
  variance_prior_df = 2,
  effect_size = 2,
  return_summarized_experiment = FALSE
)
}
\arguments{
\item{n_proteins}{the number of rows in the dataset}

\item{n_conditions}{the number of conditions. Default: 2}

\item{n_replicates}{the number of replicates per condition.
Can either be a single number or a vector with
\code{length(n_replicates) == n_conditions}. Default: 3}

\item{frac_changed}{the fraction of proteins that actually
differ between the conditions. Default: 0.1}

\item{dropout_curve_position}{the point where the chance
to observe a value is 50\%. Can be a single number or
a vector of \code{length(dropout_curve_position) == n_conditions * n_replicates}.
Default: 18.5}

\item{dropout_curve_scale}{The width of the dropout curve.
Negative numbers mean that lower intensities are more likely
to be missing.
Can be a single number or a vector of
\code{length(dropout_curve_position) == n_conditions * n_replicates}.
Default: -1.2}

\item{location_prior_mean, location_prior_scale}{the position and the variance around which the individual
condition means (\code{t_mu}) scatter. Default: 20 and 4}

\item{variance_prior_scale, variance_prior_df}{the scale and the degrees of freedom of the inverse
Chi-squared distribution used as a prior for the
variances. Default: 0.05 and 2}

\item{effect_size}{the standard deviation that is used to draw
different values for the \code{frac_changed} part of the
proteins. Default: 2}

\item{return_summarized_experiment}{a boolean indicator if
the method should return a \code{SummarizedExperiment}
object instead of a list. Default: \code{FALSE}}
}
\value{
a list with the following elements
  \describe{
    \item{Y}{the intensity matrix including the missing values}
    \item{Z}{the intensity matrix before dropping out values}
    \item{t_mu}{a matrix with \code{n_proteins} rows and
       \code{n_conditions} columns that contains the underlying
       means for each protein}
    \item{t_sigma2}{a vector with the true variances for each
       protein}
    \item{changed}{a vector with boolean values if the
       protein is actually changed}
    \item{group}{the group structure mapping samples to conditions}
  }
  if \code{return_summarized_experiment} is \code{FALSE}. Otherwise
  returns a \code{SummarizedExperiment} with the same information.
}
\description{
Generate a dataset according to the probabilistic dropout model
}
\examples{
  syn_data <- generate_synthetic_data(n_proteins = 10)
  names(syn_data)
  head(syn_data$Y)

  # Returning a SummarizedExperiment
  se <- generate_synthetic_data(n_proteins = 10, return_summarized_experiment = TRUE)
  se
  head(SummarizedExperiment::assay(se))

}
