% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Raw_Methods.R, R/SetMethods.R
\name{plotTIC}
\alias{plotTIC}
\alias{plotTIC,ptrRaw-method}
\alias{plotTIC,ptrSet-method}
\title{plot the Total Ion sptectrum (TIC) for one or several files.}
\usage{
plotTIC(
  object,
  type = c("plotly", "ggplot")[1],
  baselineRm = FALSE,
  showLimits = FALSE,
  ...
)

\S4method{plotTIC}{ptrRaw}(object, type, baselineRm, showLimits, fracMaxTIC = 0.8, ...)

\S4method{plotTIC}{ptrSet}(
  object,
  type,
  baselineRm,
  showLimits,
  pdfFile = NULL,
  fileNames = NULL,
  colorBy = "rownames",
  normalizePrimariIon = FALSE,
  ...
)
}
\arguments{
\item{object}{ptrSet or ptrRaw S4 object}

\item{type}{set 'plotly' to get an interactive plot, and 'ggplot' for 
classical plot.}

\item{baselineRm}{logical. If \code{TRUE}, remove the baseline of the TIC}

\item{showLimits}{logical. If \code{TRUE}, add the time limits to the plot 
(obtain with the `fracMaxTIC` argument or `createPtrSet` function)}

\item{...}{not used}

\item{fracMaxTIC}{Percentage (between 0 and 1) of the maximum of the Total 
Ion Current (TIC) amplitude with baseline removal. We will analyze only the 
part of the spectrum where the TIC intensity is higher than 
`fracMaxTIC * max(TIC) `. If you want to analyze the entire spectrum, set 
this parameter to 0.}

\item{pdfFile}{a absolute file path. A pdf will be generated with a plot 
for each file, caints TIC and 
time limits.}

\item{fileNames}{vector of character. The file names of the ptrSer that 
you want to plot. Could be in 
basename or fullname.}

\item{colorBy}{character. A name of the ptrSet's sampleMetaData column, 
to display with
the same color files of same attributes.}

\item{normalizePrimariIon}{should the TIC be normalized by the primary ion}
}
\value{
a plotly of ggplot2 object.
}
\description{
plot the Total Ion sptectrum (TIC) for one or several files.
}
\examples{
### ptrRaw object

library(ptairData)
filePath <- system.file('extdata/exhaledAir/ind1', 'ind1-1.h5', 
package = 'ptairData')
raw <- readRaw(filePath)
p <- plotTIC(raw)
p
dirRaw <- system.file("extdata/exhaledAir", package = "ptairData")
exhaledPtrset <- createPtrSet(dir=dirRaw, setName="exhaledPtrset", 
mzCalibRef = c(21.022, 60.0525), fracMaxTIC = 0.7, saveDir = NULL )
plotTIC(exhaledPtrset ,type='ggplot')
}
