% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coveragePlot.R
\name{coveragePlot}
\alias{coveragePlot}
\title{Plot peptide sequence coverage}
\usage{
coveragePlot(MSnSetObj, ProteinID, ProteinName, fastaFile, myCol = "brown")
}
\arguments{
\item{MSnSetObj}{MSnSet: an object of class MSnSet}

\item{ProteinID}{character: Uniprot ID of the protein}

\item{ProteinName}{character: name of the protein}

\item{fastaFile}{character: fasta file of protein sequence}

\item{myCol}{colour: colour for plotting}
}
\value{
An object created by \code{ggplot}
}
\description{
Computes and displays peptide sequence coverage in proteomics experiment
}
\details{
In the qPLEX-RIME experiment it is imperative for bait protein to have good
sequence coverage.  This function plots the protein sequence coverage of the
bait protein in the qPLEX-RIME experiment. It requires the fasta sequence
file of bait protein as input to generate the plot.
}
\examples{

data(human_anno)
data(exp3_OHT_ESR1)
MSnSet_data <- convertToMSnset(exp3_OHT_ESR1$intensities_qPLEX1, 
                               metadata=exp3_OHT_ESR1$metadata_qPLEX1,
                               indExpData=c(7:16), 
                               Sequences=2, 
                               Accessions=6)
mySequenceFile <- system.file('extdata', 
                              "P03372.fasta", 
                              package="qPLEXanalyzer")
coveragePlot(MSnSet_data, 
             ProteinID="P03372", 
             ProteinName="ERa", 
             fastaFile=mySequenceFile)

}
