% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizeIntensities.R
\name{summarizeIntensities}
\alias{summarizeIntensities}
\title{Summarizes peptides intensities to proteins}
\usage{
summarizeIntensities(MSnSetObj, summarizationFunction, annotation)
}
\arguments{
\item{MSnSetObj}{MSnSet; an object of class MSnSet}

\item{summarizationFunction}{function; method used to aggregate the peptides
into proteins. Sum, mean or median}

\item{annotation}{data.frame; a data.frame of protein annotation of four
columns: "Accessions", "Gene", "Description" and "GeneSymbol"}
}
\value{
An object of class \code{MSnSet} (see \code{\link{MSnSet-class}})
}
\description{
Summarizes multiple peptides intensities measurements to protein level.
}
\examples{

data(human_anno)
data(exp3_OHT_ESR1)
MSnSet_data <- convertToMSnset(exp3_OHT_ESR1$intensities_qPLEX1, 
                               metadata=exp3_OHT_ESR1$metadata_qPLEX1,
                               indExpData=c(7:16), 
                               Sequences=2, 
                               Accessions=6)
MSnset_P <- summarizeIntensities(MSnSet_data, sum, human_anno)

}
