% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputeIntensity-functions.R
\name{imputeKNN}
\alias{imputeKNN}
\title{k-nearest neighbor imputation}
\usage{
imputeKNN(
  x,
  k = 10,
  type = c("gower", "euclidean"),
  by = c("feature", "sample"),
  scale = FALSE,
  ...
)
}
\arguments{
\item{x}{A matrix-like object.}

\item{k}{An integer specifying the number of nearest neighbors to be used in
imputation.}

\item{type}{A string specifying the distance metric to be used. Either
"gower" or "euclidean".}

\item{by}{A string specifying whether the imputation is performed by
k-nearest features or by k-nearest samples. Either "feature" or "sample".}

\item{scale}{A logical specifying whether \code{x} needs to be standardized prior
to the imputation when Euclidean distance is used. The imputed values are
re-transformed so that they are on the original scales.}

\item{...}{Arguments passed to \link[VIM:kNN]{VIM::kNN} (Gower distance) or
\link[impute:impute.knn]{impute::impute.knn} (Euclidean distance).}
}
\value{
A matrix of the same dimension as \code{x} containing the imputed
intensities.
}
\description{
Performs k-nearest neighbor (kNN) imputation on a matrix-like object where
rows represent features and columns represent samples. This function finds
k-nearest neighbors using either Gower distance or Euclidean distance.
}
\details{
The kNN imputation based on Euclidean distance typically requires
standardization of input data to avoid variance-based weighting of variables
(make variables on similar scales). When Gower distance is used, the
imputation can be done with original units (would get the same result with
the standardized input on a different scale). The \code{type} "gower" utilizes
the \link[VIM:kNN]{VIM::kNN} and "euclidean" uses the \link[impute:impute.knn]{impute::impute.knn}.
}
\examples{

data(faahko_se)

m <- assay(faahko_se, "raw")
imputeKNN(m)

}
\references{
Trevor Hastie, Robert Tibshirani, Balasubramanian Narasimhan and Gilbert Chu
(2021). impute: impute: Imputation for microarray data. R package version
1.66.0.

Alexander Kowarik, Matthias Templ (2016). Imputation with the R Package VIM.
Journal of Statistical Software, 74(7), 1-16. doi:10.18637/jss.v074.i07
}
\seealso{
See \link{imputeIntensity} that provides a
\linkS4class{SummarizedExperiment}-friendly wrapper for this function.

See \link[VIM:kNN]{VIM::kNN} and \link[missForest:missForest]{missForest::missForest} for the underlying functions
that do work.
}
