% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizeIntensity-functions.R
\name{normalizePQN}
\alias{normalizePQN}
\title{Probabilistic quotient normalization (PQN)}
\usage{
normalizePQN(x, ref_samples = NULL, min_frac = 0.5, type = c("median", "mean"))
}
\arguments{
\item{x}{A matrix-like object.}

\item{ref_samples}{A vector of sample names or column indices specifying
reference samples for the calculation of quotients. Must be a subset of
\code{colnames(x)} if it is a character vector. If \code{NULL}, all
samples are used.}

\item{min_frac}{A numeric value between 0 and 1 specifying a minimum
proportion of reference samples for features to be included in the
calculation of a reference spectrum.}

\item{type}{A method to compute a reference spectrum. Either "median" or
"mean".}
}
\value{
A matrix of the same dimension as \code{x} containing the normalized
intensities.
}
\description{
Performs probabilistic quotient normalization (PQN) on a matrix-like object
where rows present features and columns represent samples.
}
\details{
For the calculation of quotients, a reference spectrum needs to be obtained
from a median or mean spectrum based on all spectra of the study or a subset
of the study. Feature intensities are normalized by the median of quotients.
See Dieterle et al. (2006) for details.
}
\examples{

data(faahko_se)

m <- assay(faahko_se, "knn")
normalizePQN(m)

}
\references{
Dieterle F, Ross A, Schlotterbeck G, Senn H. Probabilistic quotient
normalization as robust method to account for dilution of complex biological
mixtures. Application in 1H NMR metabonomics. Anal Chem. 2006 Jul
1;78(13):4281-90. doi: 10.1021/ac051632c. PMID: 16808434.
}
\seealso{
See \link{normalizeIntensity} that provides a
\linkS4class{SummarizedExperiment}-friendly wrapper for this function.
}
