% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annot_rse.R
\name{annot_snps}
\alias{annot_snps}
\alias{annot_snps.GRanges}
\alias{annot_snps.SummarizedExperiment}
\title{Annotate known SNP positions}
\usage{
annot_snps(obj, ...)

\method{annot_snps}{GRanges}(
  obj,
  dbsnp,
  chrom = NULL,
  col_to_aggr = "RefSNP_id",
  drop = FALSE,
  genome = NULL,
  RLE = TRUE,
  ...
)

\method{annot_snps}{SummarizedExperiment}(obj, ...)
}
\arguments{
\item{obj}{GRanges or SummarizedExperiment  object}

\item{...}{For the generic, further arguments to pass to specific methods.
Unused for now.}

\item{dbsnp}{SNPlocs package, see available packages from
\code{\link[BSgenome:injectSNPs]{BSgenome::available.SNPs()}}}

\item{chrom}{only operate on a specified chromosome}

\item{col_to_aggr}{column from SNPlocs package to add to
input. If multiple SNPs overlap these values will be concatenated
as comma separated values.}

\item{drop}{If TRUE, remove sites overlapping SNPs}

\item{genome}{A BSgenome object, which if supplied, will be used to provide
additional \code{snp_ref_allele} and \code{snp_alt_alleles} columns containing the
reference and alt allele sequences, with respect to the positive strand.
Additionally the snp sequences will be checked against the allele at the site
if a column named \code{ALT} is present in object. The strand of the site will be
used to determine if the \code{ALT} allele needs to be complemented prior to
comparing against the SNP db (which always returns sequences w.r.t the
plus strand).}

\item{RLE}{If TRUE, columns added will returned as \code{\link[S4Vectors:Rle-class]{S4Vectors::Rle()}} vectors
to reduce memory usage.}
}
\value{
Either a GRanges or SummarizedExperiment object with
a new column added with information from \code{col_to_aggr} and optionally
\code{snp_ref_allele}, \code{snp_alt_alleles}, and \code{snp_matches_site} annotations.
}
\description{
This function will annotate a \link{GRanges} or the rowRanges of
a \link{SummarizedExperiment} with SNPs from a SNP package.
}
\examples{
if (require(SNPlocs.Hsapiens.dbSNP144.GRCh38)) {
    gr <- GRanges(rep("22", 10),
        IRanges(
            seq(10510077,
                10610077,
                by = 1000
            )[1:10],
            width = 250
        ),
        strand = "+"
    )
    genome(gr) <- "GRCh38.p2"
    annot_snps(gr, SNPlocs.Hsapiens.dbSNP144.GRCh38)
}
}
\seealso{
\href{https://bioconductor.org/packages/release/data/annotation/html/SNPlocs.Hsapiens.dbSNP144.GRCh38.html}{SNPlocs.Hsapiens.dbSNP144.GRCh38}
}
