% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessorFunctions.R
\name{scanNumber}
\alias{scanNumber}
\title{Accessor function for scan number of \code{rawrrSpectrum} objects}
\usage{
scanNumber(x)
}
\arguments{
\item{x}{A rawrrSpectrum object}
}
\value{
The scan number of type \code{integer}
}
\description{
Accessor function for scan number of \code{rawrrSpectrum} objects
}
\details{
This accessor function returns the scan number of a mass spectrum
stored as \code{rawrrSpectrum} object. Scan numbers are equal to the scan index
\eqn{j} running from 1 to \eqn{n} with \eqn{n} being the last scan of a raw file.
}
\examples{
S <- readSpectrum(rawfile = sampleFilePath(), 1:10)
scanNumber(S[[1]])
}
