% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_metadata.R
\name{read_metadata}
\alias{read_metadata}
\title{Read the metadata files}
\usage{
read_metadata(metadata_files)
}
\arguments{
\item{metadata_files}{A \code{character()} with the local path to \code{recount3}
metadata files.}
}
\value{
A \code{data.frame()} with all lower case column names for the sample
metadata.
}
\description{
This function reads in the \code{recount3} metadata files into R. You can first
locate the files using \code{locate_url()} then download it to your computer
using \code{file_retrieve()}.
}
\examples{

## Download the metadata files for project ERP110066
url_ERP110066_meta <- locate_url(
    "ERP110066",
    "data_sources/sra"
)
local_ERP110066_meta <- file_retrieve(
    url = url_ERP110066_meta
)

## Read the metadata
ERP110066_meta <- read_metadata(local_ERP110066_meta)
dim(ERP110066_meta)
colnames(ERP110066_meta)

## Read the metadata files for a project in a collection
## Note: using the test files since I can't access collections right now
## for this collection
ERP110066_collection_meta <- read_metadata(
    metadata_files = file_retrieve(
        locate_url(
            "ERP110066",
            "collections/geuvadis_smartseq",
            recount3_url = "http://snaptron.cs.jhu.edu/data/temp/recount3"
        )
    )
)
dim(ERP110066_collection_meta)
## New columns for this collection
colnames(ERP110066_collection_meta)[!colnames(ERP110066_collection_meta) \%in\% colnames(ERP110066_meta)]

## Read the metadata for a mouse project
DRP002367_meta <- read_metadata(
    metadata_files = file_retrieve(
        locate_url("DRP002367", "data_sources/sra", organism = "mouse")
    )
)
dim(DRP002367_meta)

## Locate and read the GTEx bladder metadata
gtex_bladder_meta <- read_metadata(
    file_retrieve(
        locate_url("BLADDER", "data_sources/gtex")
    )
)

dim(gtex_bladder_meta)
colnames(gtex_bladder_meta)
}
\seealso{
Other internal functions for accessing the recount3 data: 
\code{\link{annotation_ext}()},
\code{\link{create_rse_manual}()},
\code{\link{file_retrieve}()},
\code{\link{locate_url}()},
\code{\link{locate_url_ann}()},
\code{\link{project_homes}()},
\code{\link{read_counts}()}
}
\concept{internal functions for accessing the recount3 data}
