% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_characteristics.R
\name{geo_characteristics}
\alias{geo_characteristics}
\title{Build a data.frame from GEO's charactersitics for a given sample}
\usage{
geo_characteristics(pheno)
}
\arguments{
\item{pheno}{A \link[S4Vectors:DataFrame-class]{DataFrame-class} as created by
\link{geo_info}.}
}
\value{
A 1 row data.frame with the characteristic fields as column names
and the values as the entries on the first row. If the authors of the study
used the same names for all samples, you can then combine them using
\link[base:cbind]{rbind}.
}
\description{
This function builds a data.frame from the GEO characteristics extracted
for a given sample. The names of the of columns correspond to the field
names. For a given SRA project, this information can be combined for all
samples as shown in the examples section.
}
\examples{

## Load required library
library("SummarizedExperiment")

## Get the GEO accession ids
# geoids <- sapply(colData(rse_gene_SRP009615)$run[1:2], find_geo)
## The previous example code works nearly all the time but it
## can occassionally fail depending on how rentrez is doing.
## This code makes sure that the example code runs.
geoids <- tryCatch(
    sapply(colData(rse_gene_SRP009615)$run[1:2], find_geo),
    error = function(e) {
        c(
            "SRR387777" = "GSM836270",
            "SRR387778" = "GSM836271"
        )
    }
)

## Get the data from GEO
geodata <- do.call(rbind, sapply(geoids, geo_info))

## Add characteristics in a way that we can access easily later on
geodata <- cbind(geodata, geo_characteristics(geodata))

## Explore the original characteristics and the result from
## geo_characteristics()
geodata[, c("characteristics", "cells", "shrna.expression", "treatment")]
}
\author{
Leonardo Collado-Torres
}
