% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_info.R
\name{geo_info}
\alias{geo_info}
\title{Extract information from GEO for a given sample}
\usage{
geo_info(
  geoid,
  verbose = FALSE,
  sleep = 1/2,
  getGPL = FALSE,
  destdir = tempdir(),
  ...
)
}
\arguments{
\item{geoid}{A character vector of length 1 with the GEO accession id for
a given sample.}

\item{verbose}{If \code{TRUE} the \code{geoid} will be shown.}

\item{sleep}{The number of seconds (or fraction) to wait before downloading
data using \link[GEOquery:getGEO]{getGEO}. This is important if you are looking over
\code{geo_info()} given the constraints published at
\url{https://www.ncbi.nlm.nih.gov/books/NBK25497/}.}

\item{getGPL}{This argument is passed to \link[GEOquery:getGEO]{getGEO} and is set
to \code{FALSE} by default to speed up the process.}

\item{destdir}{This argument is passed to \link[GEOquery:getGEO]{getGEO}.}

\item{...}{Additional arguments passed to \link[GEOquery:getGEO]{getGEO}.}
}
\value{
Returns a \link[S4Vectors:DataFrame-class]{DataFrame-class} with the information
from GEO available for the given sample.
}
\description{
This function uses GEOquery to extract information for a given sample. The
GEO accession ids for the sample can be found in the study phenotype table.
}
\examples{
geo_info("GSM836270")
}
\author{
Leonardo Collado-Torres, Andrew Jaffe
}
