% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_counts.R
\name{scale_counts}
\alias{scale_counts}
\title{Scale the raw counts provided by the recount project}
\usage{
scale_counts(
  rse,
  by = "auc",
  targetSize = 4e+07,
  L = 100,
  factor_only = FALSE,
  round = TRUE
)
}
\arguments{
\item{rse}{A \link[SummarizedExperiment:RangedSummarizedExperiment-class]{RangedSummarizedExperiment-class}
object as downloaded with \link{download_study}.}

\item{by}{Either \code{auc} or \code{mapped_reads}. If set to \code{auc} it
will scale the counts by the total coverage of the sample. That is, the area
under the curve (AUC) of the coverage. If set to \code{mapped_reads} it will
scale the counts by the number of mapped reads, whether the library was
paired-end or not, and the desired read length (\code{L}).}

\item{targetSize}{The target library size in number of single end reads.}

\item{L}{The target read length. Only used when \code{by = 'mapped_reads'}
since it cancels out in the calculation when using \code{by = 'auc'}.}

\item{factor_only}{Whether to only return the numeric scaling factor or
to return a \link[SummarizedExperiment:RangedSummarizedExperiment-class]{RangedSummarizedExperiment-class}
object with the counts scaled. If set to \code{TRUE}, you have to multiply
the sample counts by this scaling factor.}

\item{round}{Whether to round the counts to integers or not.}
}
\value{
If \code{factor_only = TRUE} it returns a numeric vector with the
scaling factor for each sample. If \code{factor_only = FALSE} it returns a
\link[SummarizedExperiment:RangedSummarizedExperiment-class]{RangedSummarizedExperiment-class} object with
the counts already scaled.
}
\description{
In preparation for a differential expression analysis, you will have to
choose how to scale the raw counts provided by the recount project. Note that
the raw counts are the sum of the base level coverage so you have to take
into account the read length or simply the total coverage for the given
sample (default option). You might want to do some further scaling to take
into account the gene or exon lengths. If you prefer to calculate read counts
without scaling check the function \link{read_counts}.
}
\details{
Rail-RNA \url{http://rail.bio} uses soft clipping when aligning
which is why we recommed using \code{by = 'auc'}.

If the reads are from a paired-end library, then the \code{avg_read_length}
is the average fragment length. This is taken into account when using
\code{by = 'mapped_reads'}.
}
\examples{
## Load an example rse_gene object
rse_gene <- rse_gene_SRP009615

## Scale counts
rse <- scale_counts(rse_gene)

## Find the project used as an example
project_info <- abstract_search("GSE32465")

## See some summary information for this project
project_info

## Use the following code to re-download this file
\dontrun{
## Download
download_study(project_info$project)

## Load file
load(file.path(project_info$project, "rse_gene.Rdata"))
identical(rse_gene, rse_gene_SRP009615)
}

}
\seealso{
\link{download_study}, \link{read_counts}
}
\author{
Leonardo Collado-Torres
}
