% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beadarray_metric_functions.R
\name{ba.background}
\alias{ba.background}
\alias{ba.biotinstaining.red}
\alias{ba.biotinstaining.grn}
\alias{ba.nonpolymorphic.red}
\alias{ba.nonpolymorphic.grn}
\alias{ba.bisulfiteconv1.red}
\alias{ba.restoration}
\alias{ba.specificity1.red}
\alias{ba.specificity1.grn}
\alias{ba.specificity2}
\alias{ba.extension.red}
\alias{ba.extension.grn}
\alias{ba.hybridization.hi.vs.med}
\alias{ba.hybridization.med.vs.low}
\alias{ba.targetremoval1}
\alias{ba.targetremoval2}
\alias{ba.bisulfiteconv1.grn}
\alias{ba.bisulfiteconv2}
\title{ba.background}
\usage{
ba.background(cdf, ct = "Extension")

ba.biotinstaining.red(
  rs,
  biotin.baseline,
  rm,
  cdf,
  mnum = 1,
  mtot = 17,
  cnamei = "biotin.stain.red",
  ct = "Biotin|DNP"
)

ba.biotinstaining.grn(
  gs,
  biotin.baseline,
  rm,
  cdf,
  mnum = 2,
  mtot = 17,
  cnamei = "biotin.stain.grn",
  ct = "Biotin|DNP"
)

ba.nonpolymorphic.red(
  rs,
  rm,
  cdf,
  mnum = 3,
  mtot = 17,
  cnamei = "nonpolymorphic.red",
  ct = "NP"
)

ba.nonpolymorphic.grn(
  gs,
  rm,
  cdf,
  mnum = 4,
  mtot = 17,
  cnamei = "nonpolymorphic.grn",
  ct = "NP"
)

ba.bisulfiteconv1.red(
  rs,
  rm,
  cdf,
  mnum = 5,
  mtot = 17,
  cnamei = "bisulfite.conv1.red",
  ct = "Conversion I-"
)

ba.restoration(
  gs,
  rm,
  cdf,
  addr.bkg,
  baseline = 3000,
  mnum = 6,
  mtot = 17,
  cnamei = "restoration.grn",
  ct = "RESTORATION"
)

ba.specificity1.red(
  rs,
  rm,
  cdf,
  mnum = 7,
  mtot = 17,
  cnamei = "specificityI.red"
)

ba.specificity1.grn(
  gs,
  rm,
  cdf,
  mnum = 8,
  mtot = 17,
  cnamei = "specificityI.grn"
)

ba.specificity2(
  rs,
  gs,
  rm,
  cdf,
  mnum = 9,
  mtot = 17,
  cnamei = "specificityII",
  ct = "Specificity 2"
)

ba.extension.red(
  rs,
  rm,
  cdf,
  mnum = 10,
  mtot = 17,
  cnamei = "extension.red",
  ct = "Extension.*"
)

ba.extension.grn(
  gs,
  rm,
  cdf,
  mnum = 11,
  mtot = 17,
  cnamei = "extension.grn",
  ct = "Extension.*"
)

ba.hybridization.hi.vs.med(
  gs,
  rm,
  cdf,
  mnum = 12,
  mtot = 17,
  cnamei = "hyb.hi.med",
  ct = "High|Medium"
)

ba.hybridization.med.vs.low(
  gs,
  rm,
  cdf,
  mnum = 13,
  mtot = 17,
  cnamei = "hyb.med.low",
  ct = "Low|Medium"
)

ba.targetremoval1(
  gs,
  rm,
  cdf,
  baseline = 3000,
  mnum = 14,
  mtot = 17,
  cnamei = "target.removal1",
  ct = "Extension|Target Removal 1"
)

ba.targetremoval2(
  gs,
  rm,
  cdf,
  baseline = 3000,
  mnum = 15,
  mtot = 17,
  cnamei = "target.removal2",
  ct = "Extension|Target Removal 2"
)

ba.bisulfiteconv1.grn(
  gs,
  rm,
  cdf,
  mnum = 16,
  mtot = 17,
  cnamei = "bisulfite.conv1.grn",
  ct = "Conversion I-"
)

ba.bisulfiteconv2(
  rs,
  gs,
  rm,
  cdf,
  mnum = 17,
  mtot = 17,
  cnamei = "bisulfite.conv2",
  ct = "Conversion II-"
)
}
\arguments{
\item{cdf}{Control probe data frame (required).}

\item{ct}{Column name/metric title (character, required).}

\item{rs}{Red signal matrix (required).}

\item{biotin.baseline}{Baseline signal for the biotin stain 
assay (required).}

\item{rm}{Results matrix containing control metrics (required).}

\item{mnum}{Metric number out of total (numeric).}

\item{mtot}{Total metrics to be calculated (numeric, 17).}

\item{cnamei}{Column name (character, required).}

\item{gs}{Green signal matrix (required).}

\item{addr.bkg}{Background signal probe address (required).}

\item{baseline}{Baseline measure for signals (integer, 3000).}
}
\description{
Get background signal for BeadArray metric calculations.

Get the Biotin staining Red BeadArray metric.

Get the Biotin staining Green BeadArray metric.

Get the Non-polymorphic Red BeadArray metric.

Get the Non-polymorphic Green BeadArray metric.

Get the Bisulfite Conversion I Red BeadArray metric.

Get the Restoration BeadArray metric.

Get the Specificity I Red BeadArray metric.

Get the Specificity I Green BeadArray metric.

Get the Specificity II Green BeadArray metric.

Get the Extension Red BeadArray metric.

Get the Extension Green BeadArray metric.

Get the Hybridication (high vs. medium) BeadArray metric.

Get the Hybridication (medium vs. low) BeadArray metric.

Get the Target Removal 1 BeadArray metric.

Get the Target Removal 2 BeadArray metric.

Get the Bisulfite Conversion I Green BeadArray metric.

Get the Bisulfite Conversion II BeadArray metric.
}
