% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomizeRegionsPerc.R
\name{randomizeRegionsPerc}
\alias{randomizeRegionsPerc}
\title{randomizeRegionsPerc}
\usage{
randomizeRegionsPerc(GR, genome = "hg19", frac = 0.2, ...)
}
\arguments{
\item{GR}{a \link[GenomicRanges:GRanges-class]{GRanges} object with the input region set.}

\item{genome}{genome of reference to generate the similar region sets. (default = "hg19)}

\item{frac}{fraction of the original region set to randomize. (default = 0.2)}

\item{...}{further arguments to be passed to other methods.}
}
\value{
a \link[GenomicRanges:GRanges-class]{GRanges} object
}
\description{
Create a random region set similar to a reference region set.
}
\details{
This function takes an input region set and generates a region set where a
fraction of the regions has been randomized.
}
\examples{

data("cw_Alien")

nreg <- 100

regA <-
  createRandomRegions(
  nregions = nreg,
  length.mean = 100,
  length.sd = 10,
  non.overlapping = TRUE,
  genome = AlienGenome
 )

regA_02 <- randomizeRegionsPerc(GR = regA, genome = AlienGenome, frac = 0.2)

}
\seealso{
\code{\link[=similarRegionSet]{similarRegionSet()}}
}
