# getMatrix retrieves the correct data

    Code
      getMatrix(cw_Alien_ReG)
    Output
                  regC_06  regC_05  regC_04  regC_03  regC_02     regC  regC_01
      regC_06    13.67852  2.73945  2.90714  3.58053  4.80962  5.53343  4.90723
      regC_05     2.91258 13.67018  3.98765  4.42063  5.90996  6.72314  6.43919
      regC_04     2.97894  3.73715 13.98435  6.43771  6.46487  7.73237  7.20437
      regC_03     3.90182  4.39901  5.79606 14.32145  7.44111  9.53856  8.47718
      regC_02     4.85191  5.92753  6.13899  7.46548 13.33420 10.59287  9.48266
      regC        5.75389  6.77407  7.97189  9.48071 10.99922 13.77912 12.18624
      regC_01     4.79544  6.75063  6.91309  8.80872  9.73464 12.28554 13.10116
      regB_05     0.20654  0.05875  0.06387  0.20216  0.19283  0.18946  0.20705
      regB_04    -0.07124 -0.07556 -0.07518 -0.07396  0.06491 -0.07248 -0.07471
      regB_03    -0.07214 -0.07267  0.05602  0.06474  0.05257  0.06278  0.05935
      regB_02     0.06083  0.05964  0.06267  0.19422  0.19400  0.19693  0.17957
      regB        0.06640  0.06047  0.06101  0.20089  0.19175  0.19778  0.18496
      regB_01     0.06549  0.06341  0.06129  0.20519  0.18750  0.19551  0.18318
      regB_08     0.05856  0.21048  0.06060  0.18947  0.05975  0.18969  0.19777
      regB_07     0.06520  0.05204 -0.07511 -0.07446 -0.07656 -0.07818 -0.07596
      regB_06     0.19492  0.06502 -0.07730  0.20487  0.05832  0.05642  0.19489
      regAB_06    0.19306  0.33389  0.18847  0.19318  0.32456  0.33628  0.19372
      regAB_04    0.06262  0.06003  0.05486  0.06043  0.06120  0.05399  0.06075
      regAB       0.06086  0.05619 -0.07499  0.07053  0.06105  0.06736  0.06057
      regAB_02    0.05840  0.05830 -0.07072  0.07110  0.19319  0.07524  0.06232
      regA_07    -0.07615 -0.07675 -0.08014 -0.07417 -0.07688 -0.07627 -0.06956
      regA_06     0.05311 -0.07817 -0.07582 -0.07475 -0.07671 -0.07939 -0.07381
      regA_05    -0.07738  0.05851 -0.07628  0.05103  0.05490  0.05498  0.05577
      regA_04    -0.07494 -0.07582 -0.07878 -0.07393 -0.07996 -0.07982 -0.07893
      regA_03    -0.07487 -0.07503 -0.07563 -0.07788 -0.07279 -0.07540 -0.07532
      regA_02    -0.07257 -0.07512 -0.07538 -0.07692 -0.07632 -0.07794 -0.07471
      regA       -0.07357 -0.07478 -0.07889 -0.07359 -0.07361 -0.07802 -0.07529
      regA_01    -0.07397 -0.07761 -0.07635 -0.07246 -0.07382 -0.07794 -0.07442
      regD_08    -0.07614  0.06042  0.20087  0.20600  0.04966  0.05165  0.05455
      regD_06     0.05316 -0.07494 -0.07473 -0.07676  0.05864 -0.07515  0.06985
      regD_04    -0.07749 -0.07777  0.05994  0.05554 -0.07124 -0.07377 -0.07498
      regD       -0.07630 -0.07828 -0.07550  0.05734 -0.07453 -0.07759 -0.07556
      regD_02    -0.07585 -0.07745 -0.07655  0.05978 -0.07353 -0.07703 -0.07281
      regAB_08    0.06164  0.07082 -0.07342  0.06599  0.06789  0.19028  0.19815
      regC_08     0.89638  1.40955  1.77216  1.90289  2.20779  2.72735  2.10231
      regC_07     1.29875  2.08666  2.18140  2.54814  2.93466  3.85475  3.64116
      regA_08    -0.07281 -0.07224 -0.07509 -0.07713 -0.07506 -0.07549 -0.07059
      regC_09     0.47771  0.31237  0.75192  1.01976  0.72955  1.31838  1.27239
      regB_09    -0.07794 -0.07210  0.05536  0.07420 -0.07400 -0.07397  0.06003
      reg_no_B    0.06606 -0.07272 -0.07199  0.18827  0.05653  0.06337  0.05217
      regA_09    -0.07752 -0.07973 -0.07715  0.06354 -0.07248 -0.07472 -0.07441
      reg_no_AB  -0.07190  0.35239  0.18411  0.19368  0.33382  0.30905  0.31065
      reg_no_C    0.05796 -0.07525 -0.07502 -0.07683 -0.07732 -0.07563 -0.07518
      reg_no_ABC  0.06955 -0.07477 -0.07384 -0.07691 -0.07310 -0.07182 -0.07731
      reg_no_A    0.05889  0.05985 -0.07290 -0.07465  0.05715  0.06298  0.05858
                  regB_05  regB_04  regB_03  regB_02     regB  regB_01  regB_08
      regC_06     0.21425 -0.07550 -0.07293  0.05939  0.05634  0.05748  0.05689
      regC_05     0.06704 -0.07629 -0.07805  0.05495  0.06227  0.06279  0.19575
      regC_04     0.06103 -0.07712  0.05916  0.05924  0.05557  0.06369  0.05713
      regC_03     0.19015 -0.07604  0.05744  0.18242  0.19260  0.20280  0.18526
      regC_02     0.20344  0.05515  0.05747  0.18924  0.19599  0.21095  0.05137
      regC        0.19754 -0.07758  0.05439  0.18983  0.19446  0.21289  0.18463
      regC_01     0.19840 -0.07661  0.05418  0.18105  0.18706  0.20746  0.18569
      regB_05    13.36879  4.35276  5.34353  5.07888  7.27971  6.39943  1.53901
      regB_04     4.12031 14.09296  5.27903  6.35933  8.39689  7.25565  1.50166
      regB_03     4.93044  5.47937 13.47783  7.59060  9.43506  8.92977  1.76526
      regB_02     4.89800  6.58328  8.08379 13.13449 10.96239 10.24030  1.92486
      regB        6.51303  8.21820  9.57829 10.71680 13.63943 12.42926  2.56141
      regB_01     6.07000  7.55609  9.11369  9.97645 12.24774 13.91879  2.50599
      regB_08     1.61287  1.58175  1.78765  2.06436  2.58931  2.54780 12.99697
      regB_07     1.41987  2.45677  2.68585  3.33111  4.10026  3.63736  0.44815
      regB_06     2.52009  3.31435  3.42941  4.38904  5.49068  4.81812  0.94649
      regAB_06    1.26491  1.94130  2.24675  2.55734  2.86276  2.83429  0.85499
      regAB_04    2.27172  2.03132  2.61293  3.14950  4.09440  3.33444  1.29781
      regAB       3.29959  4.10359  4.75116  5.34490  6.90651  5.97811  1.64034
      regAB_02    2.55623  2.93991  4.17120  4.34360  5.23864  4.59831  1.41971
      regA_07    -0.08026  0.05523  0.05463  0.05840  0.06184 -0.07096  0.20213
      regA_06    -0.07892  0.19365 -0.07557 -0.07274 -0.07395 -0.07369 -0.07861
      regA_05     0.05996 -0.07300 -0.07359  0.05774  0.06207 -0.07228  0.32520
      regA_04    -0.07569 -0.07891 -0.07859 -0.07400 -0.07627 -0.07273  0.20494
      regA_03     0.05326 -0.07183 -0.07495  0.05885  0.05648 -0.07767  0.33642
      regA_02     0.19035 -0.07589 -0.07503  0.06232  0.06071  0.05919  0.18895
      regA        0.06134 -0.07862 -0.07611  0.05991  0.06021 -0.07449  0.20156
      regA_01     0.06177 -0.07642 -0.07585  0.05534  0.05695 -0.07420  0.20986
      regD_08     0.05843  0.05507 -0.07532  0.06028  0.06032  0.06322  0.19228
      regD_06    -0.07474 -0.07716  0.19113 -0.07353 -0.07777 -0.07734 -0.07906
      regD_04    -0.07183 -0.07877 -0.07525 -0.07440 -0.07700 -0.07512  0.05883
      regD       -0.07198  0.05100  0.19720  0.06817  0.05947  0.06088  0.06249
      regD_02    -0.07307  0.05420  0.20354  0.07210  0.05924  0.06258  0.06127
      regAB_08    0.48282  1.15579  1.14756  1.25836  1.44518  1.09614  0.34367
      regC_08    -0.08101 -0.07361  0.05594 -0.07689 -0.07169 -0.07367 -0.07715
      regC_07    -0.07310 -0.07468 -0.07717 -0.07678 -0.07458 -0.07254  0.06119
      regA_08    -0.07070 -0.07569 -0.07839  0.06504 -0.07862 -0.07656 -0.07383
      regC_09     0.18913 -0.07759  0.06120  0.18739  0.20149  0.18701  0.06541
      regB_09     0.49812  0.75505  0.61625  1.04700  1.31808  0.96944  0.33187
      reg_no_B    0.05455 -0.07460  0.06306  0.05003  0.05218  0.05687  0.05931
      regA_09    -0.08103  0.05390  0.06142  0.06033  0.05846  0.07054 -0.07642
      reg_no_AB  -0.07399  0.04786 -0.07455 -0.07372 -0.07829 -0.07632 -0.07215
      reg_no_C   -0.07336 -0.07711 -0.07790 -0.07041 -0.07376 -0.07353 -0.07702
      reg_no_ABC  0.06171  0.07187 -0.07584  0.21016  0.06055  0.05875 -0.07870
      reg_no_A   -0.07674 -0.07156 -0.07173 -0.07780 -0.07526 -0.07803  0.05146
                  regB_07  regB_06 regAB_06 regAB_04    regAB regAB_02  regA_07
      regC_06     0.06032  0.18654  0.19615  0.05562  0.05743  0.06016 -0.07716
      regC_05     0.06576  0.05776  0.33131  0.06199  0.06063  0.07026 -0.07266
      regC_04    -0.07053 -0.07613  0.19413  0.05547 -0.07382 -0.07324 -0.07111
      regC_03    -0.06967  0.21332  0.18699  0.05323  0.06088  0.06733 -0.07709
      regC_02    -0.06784  0.06399  0.33902  0.05653  0.06608  0.20869 -0.07666
      regC       -0.06939  0.06690  0.34907  0.05611  0.06240  0.07429 -0.07628
      regC_01    -0.06964  0.21495  0.19642  0.05244  0.05725  0.07344 -0.07628
      regB_05     1.38655  2.41861  1.26497  2.07447  3.42769  2.52297 -0.07485
      regB_04     2.48227  3.30648  1.94114  1.80878  4.16167  2.86313  0.05992
      regB_03     2.72059  3.50665  2.25472  2.51503  4.98525  4.31205  0.05609
      regB_02     3.23704  4.41948  2.64578  3.07658  5.53164  4.61371  0.05984
      regB        4.00823  5.25411  3.01389  3.72290  6.91332  5.46981  0.05547
      regB_01     3.60595  4.64278  2.80273  3.19694  5.95189  4.74994 -0.07712
      regB_08     0.49071  1.07034  0.85723  1.22796  1.67326  1.43303  0.19329
      regB_07    13.58409  1.88616  0.86253  0.58698  2.05372  1.14664  0.18837
      regB_06     1.89642 13.72355  1.73230  1.29453  2.92850  2.28548  0.05495
      regAB_06    0.87933  1.65231 13.03000  2.99469  5.51678  3.94137  1.05119
      regAB_04    0.58587  1.24937  3.11695 14.10174  9.06348  6.42525  1.53079
      regAB       2.04485  2.80130  5.34713  8.31089 14.56000 10.86027  2.30222
      regAB_02    1.07903  2.13092  4.08746  6.49615 11.23389 13.95775  1.81189
      regA_07     0.19410  0.06490  1.00221  1.53607  2.33111  1.83052 13.33879
      regA_06     0.05263 -0.07806  0.94256  1.89491  2.78741  2.39939  1.62279
      regA_05    -0.07761  0.05544  1.30608  2.52566  3.65948  2.89127  2.94205
      regA_04     0.20372  0.06389  1.80004  2.43602  4.00329  3.03572  2.65840
      regA_03    -0.07756  0.06398  1.57605  3.36898  4.95230  4.21223  2.64989
      regA_02     0.05330  0.05823  1.78561  3.06941  4.79179  4.12450  3.18331
      regA        0.05434  0.05876  2.25326  4.31039  6.57213  5.58342  4.16260
      regA_01     0.05480  0.05980  2.23871  4.34784  6.16253  4.96968  3.69918
      regD_08    -0.07657 -0.07622  0.19599  0.33043  0.34034  0.48161  0.30964
      regD_06    -0.07533 -0.07421  0.05299  0.18899  0.18701  0.32517  0.04991
      regD_04    -0.07513 -0.07642  0.18706  0.18125  0.17802  0.31915  0.05327
      regD        0.05295 -0.07532  0.05584  0.32576  0.18178  0.31450  0.05109
      regD_02     0.05436 -0.07397  0.05428  0.33169  0.18442  0.31590  0.05205
      regAB_08    0.46247  0.58939  0.83918  1.76952  2.84128  2.32313  0.45238
      regC_08    -0.07484 -0.07220 -0.07496 -0.07804 -0.06988 -0.07718 -0.07534
      regC_07     0.06555  0.06243  0.19660 -0.07090 -0.07776 -0.07196 -0.07520
      regA_08     0.05237  0.05750  0.71879  1.00220  1.63772  1.49590  0.72792
      regC_09    -0.07619  0.05985  0.06264  0.06039  0.05382  0.05890  0.05803
      regB_09     0.49222  0.49259  0.33634  0.32246  0.76049  0.76132  0.06616
      reg_no_B   -0.07556 -0.07210  0.05027 -0.07981  0.18632  0.18589 -0.07571
      regA_09    -0.07689  0.18287  0.31963  0.20924  0.75574  0.73233  0.32133
      reg_no_AB   0.05406 -0.07628 -0.08097 -0.07854  0.05377  0.05479  0.04709
      reg_no_C    0.05677  0.05754 -0.07819  0.05936 -0.08003 -0.08013  0.04885
      reg_no_ABC  0.18589  0.06801  0.05486 -0.07175  0.06665  0.05461  0.18410
      reg_no_A    0.05692  0.05668  0.16890  0.05210  0.04294  0.05511  0.04389
                  regA_06  regA_05  regA_04  regA_03  regA_02     regA  regA_01
      regC_06     0.05853 -0.07358 -0.07189 -0.07380 -0.07615 -0.07643 -0.07749
      regC_05    -0.07615  0.06422 -0.07096 -0.07709 -0.07765 -0.07193 -0.08061
      regC_04    -0.06984 -0.07189 -0.07834 -0.07569 -0.07514 -0.07746 -0.07426
      regC_03    -0.07386  0.05513 -0.07584 -0.07371 -0.07649 -0.07143 -0.07427
      regC_02    -0.07377  0.06088 -0.07276 -0.07740 -0.07339 -0.07610 -0.07680
      regC       -0.07432  0.05633 -0.07400 -0.07848 -0.07570 -0.07689 -0.07502
      regC_01    -0.07495  0.05875 -0.07451 -0.07912 -0.07775 -0.07623 -0.07541
      regB_05    -0.08041  0.06500 -0.07441  0.05362  0.18913  0.06339  0.05222
      regB_04     0.20130 -0.07396 -0.07314 -0.07694 -0.07097 -0.07037 -0.07369
      regB_03    -0.07420 -0.07642 -0.07678 -0.07605 -0.07330 -0.07254 -0.07509
      regB_02    -0.07428  0.06415 -0.07281  0.04963  0.06367  0.06373  0.05938
      regB       -0.07343  0.06459 -0.07410  0.04932  0.06236  0.06682  0.05493
      regB_01    -0.07420 -0.07554 -0.07555 -0.07787  0.05977 -0.07282 -0.07643
      regB_08    -0.07745  0.32588  0.20253  0.31626  0.18442  0.19445  0.19758
      regB_07     0.06053 -0.07554  0.19903 -0.07982  0.05372  0.06246  0.05244
      regB_06    -0.07523  0.06123  0.06098  0.06117  0.06649  0.06557  0.05674
      regAB_06    1.00833  1.36700  1.76984  1.56090  1.73588  2.34611  2.20814
      regAB_04    1.82243  2.63201  2.51028  3.31038  3.25765  4.69723  4.15749
      regAB       2.66783  3.75376  4.14891  4.81344  4.93892  6.81250  5.81996
      regAB_02    2.35034  3.01363  3.01308  4.15486  4.21781  5.51734  4.93455
      regA_07     1.71934  2.85606  2.71428  2.58010  2.98707  3.79931  3.68967
      regA_06    12.43145  2.47703  3.39966  3.67980  4.11119  4.86779  4.27770
      regA_05     2.44188 12.72879  4.09383  4.60186  5.28570  6.92002  6.33074
      regA_04     3.37260  3.99822 11.35729  5.48558  6.11483  7.91338  6.69494
      regA_03     3.80525  4.65975  5.60047 12.26615  7.00139  8.73725  7.91467
      regA_02     4.06935  5.32758  6.02509  7.12052 13.48610  9.83627  9.50171
      regA        4.87787  6.52527  7.16644  8.70549 10.30335 12.68773 10.98625
      regA_01     4.23640  6.26525  6.32300  7.82532  9.46133 11.83540 12.54457
      regD_08     0.18206  0.44005  0.18881  0.30560  0.33470  0.31652  0.32717
      regD_06    -0.07739  0.05026  0.04675  0.17257  0.04888  0.18440  0.18707
      regD_04     0.04404  0.20587  0.18147  0.17303  0.30154  0.18047  0.16728
      regD        0.04629  0.19284  0.16734  0.16460  0.30235  0.17655  0.16953
      regD_02     0.05098  0.19516  0.16292  0.16871  0.17769  0.18043  0.16075
      regAB_08    0.45510  0.43153  0.84778  1.11314  0.85302  1.22393  1.22598
      regC_08    -0.07401 -0.07624 -0.07486 -0.07281 -0.07642 -0.07062 -0.07686
      regC_07    -0.07179  0.19903 -0.07627  0.05760  0.06143  0.05856  0.05936
      regA_08     0.92732  0.86403  1.50070  1.72018  2.13494  2.54702  2.45980
      regC_09     0.06425  0.05944 -0.07433  0.05410 -0.07758 -0.07719 -0.07437
      regB_09    -0.07410  0.05919 -0.07428 -0.07456 -0.07761 -0.07313 -0.07198
      reg_no_B    0.04880  0.31752 -0.08049  0.04839  0.05460  0.04955  0.04864
      regA_09     0.43596  0.48577  0.86916  0.89792  1.16049  1.33130  1.13775
      reg_no_AB  -0.07940 -0.07642  0.04087  0.03708 -0.07714  0.04312 -0.08245
      reg_no_C    0.29528 -0.07426  0.04575  0.04532  0.04625  0.04723  0.04484
      reg_no_ABC  0.04535  0.05796  0.05360  0.04215 -0.07782  0.04279  0.05394
      reg_no_A   -0.08744  0.05077  0.03954  0.03426  0.03813  0.04361  0.04437
                  regD_08  regD_06  regD_04     regD  regD_02 regAB_08  regC_08
      regC_06    -0.07274  0.05615 -0.07735 -0.07439 -0.08212  0.06423  0.85059
      regC_05     0.06456 -0.07535 -0.07555 -0.07254 -0.07308  0.05962  1.39891
      regC_04     0.19364 -0.07326  0.05850 -0.08078 -0.07759 -0.07629  1.85630
      regC_03     0.20048 -0.07654  0.06092  0.05464  0.05894  0.05912  1.88765
      regC_02     0.05878  0.05637 -0.07255 -0.07778 -0.07371  0.06717  2.09846
      regC        0.06019 -0.07847 -0.07490 -0.07660 -0.07373  0.19832  2.75453
      regC_01     0.05851  0.05561 -0.07644 -0.07473 -0.07393  0.19299  2.33965
      regB_05     0.05330 -0.07835 -0.07243 -0.07329 -0.07431  0.46977 -0.07229
      regB_04     0.05695 -0.07692 -0.06932  0.05892  0.05634  1.16661 -0.07577
      regB_03    -0.08133  0.17049 -0.07467  0.19458  0.18434  1.19816  0.06206
      regB_02     0.05946 -0.07638 -0.07424  0.06474  0.05394  1.35506 -0.07354
      regB        0.05903 -0.07872 -0.07382  0.05649  0.05182  1.43258 -0.07317
      regB_01     0.05369 -0.07754 -0.07540  0.05602  0.05152  1.17498 -0.07367
      regB_08     0.19587 -0.07486  0.06567  0.05212  0.05537  0.34424 -0.07376
      regB_07    -0.07643 -0.07497 -0.07099  0.05655  0.05022  0.45565 -0.07704
      regB_06    -0.07632 -0.07513 -0.07212 -0.07796 -0.07549  0.62090 -0.07319
      regAB_06    0.17957  0.05003  0.18685  0.04606  0.04963  0.85840 -0.07155
      regAB_04    0.33169  0.17627  0.20181  0.32074  0.30377  1.75433 -0.07292
      regAB       0.31412  0.17201  0.19002  0.18660  0.17987  2.82898 -0.07181
      regAB_02    0.45207  0.30862  0.32123  0.31285  0.31946  2.36520 -0.07381
      regA_07     0.30288  0.05673  0.05977  0.04884  0.05230  0.45124 -0.07102
      regA_06     0.16812 -0.08096  0.05103  0.04482  0.04185  0.44739 -0.07345
      regA_05     0.44011  0.04992  0.20221  0.19399  0.20123  0.48011 -0.07721
      regA_04     0.17158  0.04853  0.17620  0.15654  0.16357  0.86156 -0.07423
      regA_03     0.29996  0.19232  0.16777  0.17120  0.16458  1.09998 -0.07282
      regA_02     0.29764  0.06272  0.29548  0.30741  0.17366  0.86057 -0.07554
      regA        0.29738  0.19190  0.16481  0.17221  0.16028  1.25605 -0.07576
      regA_01     0.30901  0.19262  0.17078  0.17496  0.16059  1.23215 -0.07494
      regD_08    12.62808  0.96915  1.39578  2.36438  2.20405  0.06613 -0.07195
      regD_06     0.97119 12.74780  3.21533  4.94213  3.70491 -0.07629 -0.07671
      regD_04     1.42216  3.21850 12.88081  7.07280  5.93575 -0.07540 -0.07606
      regD        2.44201  5.19096  7.48152 12.06703 10.00574 -0.07866 -0.07461
      regD_02     2.18579  3.84674  5.99243  9.66522 12.60756 -0.07484  0.06123
      regAB_08    0.04904 -0.07651 -0.07538 -0.07857 -0.07635 14.92467 -0.07435
      regC_08    -0.07231 -0.07540 -0.07310 -0.07343  0.06088 -0.07539 13.10116
      regC_07    -0.07313 -0.07789  0.05302 -0.07703 -0.07898  0.06129  0.89421
      regA_08     0.04708  0.05519 -0.07459  0.05434  0.05192  0.31460 -0.07515
      regC_09    -0.07985  0.05609  0.05343  0.18936  0.18390 -0.07598  0.34207
      regB_09     0.06080  0.05937 -0.07614 -0.07422 -0.07156  0.21077 -0.07645
      reg_no_B   -0.07833 -0.07096 -0.07769 -0.07847  0.04787 -0.07529  0.18201
      regA_09    -0.07447  0.19507  0.05385  0.05101  0.05034  0.18935 -0.07613
      reg_no_AB   0.05127 -0.07832  0.04156 -0.08113 -0.08031  0.05485  0.18808
      reg_no_C   -0.07764 -0.07877  0.04233  0.04539  0.04334 -0.07245  0.07190
      reg_no_ABC  0.20494 -0.07313 -0.07629 -0.07856  0.05095  0.06214  0.06490
      reg_no_A   -0.08028  0.04708 -0.08390 -0.08230 -0.08229  0.06457 -0.06846
                  regC_07  regA_08  regC_09  regB_09 reg_no_B  regA_09 reg_no_AB
      regC_06     1.24723 -0.07703  0.47270 -0.07558  0.06774 -0.07786  -0.07788
      regC_05     1.93409 -0.07107  0.30292 -0.07660 -0.07457 -0.07239   0.35339
      regC_04     2.17041 -0.08018  0.73093  0.05960 -0.07713 -0.07465   0.19587
      regC_03     2.58101 -0.07216  1.01392  0.05333  0.16610  0.05274   0.18547
      regC_02     2.88297 -0.07672  0.69206 -0.07292  0.05044 -0.07347   0.30805
      regC        3.91880 -0.07911  1.27484 -0.07451  0.04820 -0.07411   0.30703
      regC_01     3.63870 -0.07731  1.28934  0.05397  0.04498 -0.07333   0.29402
      regB_05    -0.07560 -0.07598  0.21890  0.46003  0.06060 -0.08010  -0.07803
      regB_04    -0.07569 -0.07140 -0.07274  0.75286 -0.07273  0.06506   0.06082
      regB_03    -0.07584 -0.07717  0.07167  0.63224  0.05924  0.06186  -0.07814
      regB_02    -0.07349  0.05971  0.20858  1.00426  0.06357  0.06607  -0.07732
      regB       -0.07546 -0.07457  0.21010  1.34796  0.06322  0.06120  -0.07674
      regB_01    -0.07476 -0.07701  0.21374  1.01986  0.06234  0.06166  -0.07698
      regB_08     0.06426 -0.07576  0.06190  0.33720  0.05498 -0.07494  -0.07345
      regB_07     0.06415  0.05380 -0.07070  0.48796 -0.07773 -0.07952   0.05697
      regB_06     0.06720  0.06062  0.06402  0.48577 -0.07210  0.18751  -0.07224
      regAB_06    0.20026  0.72498  0.06276  0.33605  0.05587  0.34969  -0.08288
      regAB_04   -0.07396  0.97251  0.06147  0.34605 -0.07249  0.19400  -0.07969
      regAB      -0.07779  1.60146  0.06534  0.74399  0.19261  0.74699   0.05175
      regAB_02   -0.07906  1.50903  0.06445  0.75186  0.19983  0.72206   0.05962
      regA_07    -0.07558  0.67028  0.04805  0.05580 -0.07657  0.32473   0.04857
      regA_06    -0.08134  0.92650  0.05314 -0.07310  0.05804  0.46324  -0.08268
      regA_05     0.19215  0.84007  0.04691  0.04959  0.33313  0.46818  -0.08254
      regA_04    -0.08141  1.58169 -0.07803 -0.07376 -0.07722  0.82444   0.04157
      regA_03     0.05493  1.71914  0.05422 -0.07340  0.05539  0.95970   0.04414
      regA_02     0.05203  2.12045 -0.07440 -0.07316  0.05869  1.10159  -0.08134
      regA        0.05010  2.57061 -0.07549 -0.07427  0.05896  1.21936   0.04170
      regA_01     0.05371  2.54375 -0.07452 -0.07471  0.06186  1.08887  -0.08354
      regD_08    -0.08041  0.06385 -0.07358  0.05877 -0.07386 -0.07952   0.05884
      regD_06    -0.08028  0.04896  0.05667  0.05041 -0.07715  0.19480  -0.07539
      regD_04     0.05403 -0.07775  0.05123 -0.07512 -0.07433  0.06052   0.05182
      regD       -0.07787  0.05461  0.19046 -0.07627 -0.07618  0.06145  -0.08161
      regD_02    -0.08209  0.05623  0.19929 -0.07273  0.05778  0.05643  -0.07871
      regAB_08    0.06855  0.33349 -0.07382  0.19527 -0.07709  0.19182   0.05207
      regC_08     0.88679 -0.07506  0.33447 -0.07714  0.19275 -0.07612   0.20292
      regC_07    12.83206  0.18580  0.45446  0.19676 -0.07214  0.18075   0.05829
      regA_08     0.18237 13.34857 -0.07629  0.18924 -0.07448  0.32439   0.04610
      regC_09     0.47125 -0.07466 13.30092  0.05413 -0.07188  0.04978   0.06585
      regB_09     0.20201  0.18196  0.05339 13.11556  0.06455  0.18401  -0.07715
      reg_no_B   -0.07242 -0.07405 -0.07518  0.06415 13.30456  0.06407   0.05003
      regA_09     0.18075  0.31194  0.06703  0.18327  0.06083 12.61979   0.06047
      reg_no_AB   0.05387  0.05316  0.05887 -0.07236  0.03609  0.05742  11.61838
      reg_no_C   -0.07838  0.17495  0.05504  0.06815  0.15911 -0.07240  -0.08527
      reg_no_ABC -0.06858  0.06647  0.07668 -0.07188  0.04616 -0.07199   0.04034
      reg_no_A    0.06171 -0.08166 -0.07573 -0.07526  0.28565 -0.07454  -0.08609
                 reg_no_C reg_no_ABC reg_no_A
      regC_06     0.06496    0.06254  0.06495
      regC_05    -0.07255   -0.07671  0.05752
      regC_04    -0.07471   -0.07688 -0.07900
      regC_03    -0.07380   -0.07542 -0.07804
      regC_02    -0.07659   -0.07501  0.05018
      regC       -0.07528   -0.07539  0.05137
      regC_01    -0.07670   -0.07533  0.05084
      regB_05    -0.07878    0.06482 -0.07031
      regB_04    -0.07419    0.05642 -0.07504
      regB_03    -0.07509   -0.07659 -0.07237
      regB_02    -0.07734    0.18505 -0.07379
      regB       -0.07833    0.05391 -0.07606
      regB_01    -0.07937    0.05274 -0.07565
      regB_08    -0.07348   -0.07330  0.05124
      regB_07     0.05572    0.18621  0.05698
      regB_06     0.06186    0.06199  0.06393
      regAB_06   -0.08351    0.05641  0.18452
      regAB_04    0.05003   -0.07855  0.05594
      regAB      -0.07966    0.05234  0.05369
      regAB_02   -0.08056    0.05796  0.05740
      regA_07     0.04917    0.17917  0.05064
      regA_06     0.29182    0.03741 -0.08332
      regA_05    -0.07630    0.05311  0.05190
      regA_04     0.03835    0.05351  0.03470
      regA_03     0.03955    0.05502  0.03714
      regA_02     0.04318   -0.07740  0.03851
      regA        0.03764    0.04880  0.03455
      regA_01     0.04543    0.04989  0.04019
      regD_08    -0.08279    0.19215 -0.07590
      regD_06    -0.07834   -0.07600  0.04892
      regD_04     0.04323   -0.07621 -0.08171
      regD        0.04074   -0.07986 -0.08475
      regD_02     0.04610    0.05574 -0.08249
      regAB_08   -0.07901    0.05027  0.04761
      regC_08     0.06377    0.06997 -0.07526
      regC_07    -0.07444   -0.07045  0.05477
      regA_08     0.17714    0.05204 -0.07938
      regC_09     0.06050    0.06957 -0.07525
      regB_09     0.07298   -0.07039 -0.07011
      reg_no_B    0.17097    0.04432  0.30371
      regA_09    -0.07002   -0.07224 -0.07396
      reg_no_AB  -0.08906    0.03485 -0.08434
      reg_no_C   11.96798    0.15405  0.14956
      reg_no_ABC  0.14716   11.41799  0.15756
      reg_no_A    0.14359    0.15459 10.90789

---

    Code
      getMatrix(mLZ_regA_ReG)
    Output
                        -600        -590        -580        -570        -560
      regA_01    -0.06566777 -0.06566777 -0.06566777 -0.06566777 -0.06566777
      regA       -0.06518724 -0.06518724 -0.06518724 -0.06518724 -0.06518724
      regA_02    -0.06403979 -0.06403979 -0.06403979 -0.06403979 -0.06403979
      regA_03    -0.06555817 -0.06555817 -0.06555817 -0.06555817 -0.06555817
      regD_04    -0.06849438 -0.06849438 -0.06849438 -0.06849438 -0.06849438
      regD_06     0.04473346  0.04473346  0.04473346  0.04473346  0.04473346
      regD_02    -0.06664308 -0.06664308 -0.06664308 -0.06664308 -0.06664308
      regD       -0.06923478 -0.06923478 -0.06923478 -0.06923478 -0.06923478
      regA_09    -0.06548367 -0.06548367 -0.06548367 -0.06548367 -0.06548367
      regAB_08    0.04930056  0.04930056  0.04930056  0.04930056  0.04930056
      regA_08    -0.06135342 -0.06135342 -0.06135342 -0.06135342 -0.06135342
      regAB_06    0.16611932  0.16611932  0.16611932  0.16611932  0.16611932
      regD_08    -0.06693560 -0.06693560 -0.06693560 -0.06693560 -0.06693560
      reg_no_ABC -0.06376465 -0.06376465 -0.06376465 -0.06376465 -0.06376465
      regC_03     0.04795798  0.04795798  0.04795798  0.04795798  0.04795798
      regC_05     0.16855826  0.16855826  0.16855826  0.16855826  0.16855826
      regC_09     0.28161008  0.28161008  0.28161008  0.28161008  0.28161008
      reg_no_C    0.16501551  0.16501551  0.16501551  0.16501551  0.16501551
      regB_08     0.27160541  0.15829485  0.15829485  0.15829485  0.15829485
      reg_no_A   -0.06687758 -0.06687758 -0.06687758 -0.06687758 -0.06687758
      regB_04     0.05130219  0.05130219  0.05130219  0.05130219 -0.06476611
      regC_06     0.15962361  0.15962361  0.15962361  0.15962361  0.15962361
      regB_09    -0.06567703 -0.06567703 -0.06567703 -0.06567703 -0.06567703
      reg_no_AB  -0.06772276 -0.06772276 -0.06772276 -0.06772276 -0.06772276
      regC_04    -0.06778509 -0.06778509 -0.06778509 -0.06778509 -0.06778509
      regC_01     0.04734488  0.04734488  0.04734488  0.04734488  0.04734488
      regC        0.04993289  0.04993289  0.04993289  0.04993289  0.04993289
      regB_05     0.05010482  0.05010482  0.05010482  0.05010482  0.05010482
      regB_02     0.05154945  0.05154945  0.05154945  0.05154945  0.05154945
      regB_01     0.04900773  0.04900773  0.04900773  0.04900773  0.04900773
      regB        0.04989415  0.04989415  0.04989415  0.04989415  0.04989415
      regC_02     0.04790636  0.04790636  0.04790636  0.04790636  0.04790636
      regB_03    -0.06364593 -0.06364593 -0.06364593 -0.06364593 -0.06364593
      regC_07    -0.06681379 -0.06681379 -0.06681379 -0.06681379 -0.06681379
      reg_no_B   -0.06784694 -0.06784694 -0.06784694 -0.06784694 -0.06784694
      regB_07    -0.06851326 -0.06851326 -0.06851326 -0.06851326 -0.06851326
      regB_06     0.04947548  0.04947548  0.04947548  0.04947548  0.04947548
      regC_08     0.05146310  0.05146310  0.05146310  0.05146310  0.05146310
      regA_04    -0.06429201 -0.06429201 -0.06429201 -0.06429201 -0.06429201
      regA_05    -0.06882001 -0.06882001 -0.06882001 -0.06882001 -0.06882001
      regAB       0.05479048  0.05479048  0.05479048  0.05479048  0.05479048
      regA_06     0.04568899  0.04568899  0.04568899  0.04568899  0.04568899
      regAB_02    0.05328011  0.05328011  0.05328011  0.05328011  0.05328011
      regA_07    -0.06390469 -0.06390469 -0.06390469 -0.06390469 -0.06390469
      regAB_04    0.05634842  0.05634842  0.05634842  0.05634842  0.05634842
                        -550        -540        -530        -520        -510
      regA_01    -0.06566777  0.04833878  0.04833878  0.04833878  0.04833878
      regA       -0.06518724  0.05080429  0.05080429  0.05080429  0.05080429
      regA_02    -0.06403979  0.05052155  0.05052155  0.05052155  0.05052155
      regA_03    -0.06555817  0.04986114  0.04986114  0.04986114  0.04986114
      regD_04    -0.06849438 -0.06849438 -0.06849438 -0.06849438  0.04509498
      regD_06     0.04473346  0.04473346  0.15712910  0.15712910  0.15712910
      regD_02    -0.06664308 -0.06664308  0.04688857  0.04688857  0.16042022
      regD       -0.06923478 -0.06923478  0.04389395  0.04389395  0.15702267
      regA_09    -0.06548367  0.05187058  0.05187058  0.05187058  0.05187058
      regAB_08    0.04930056  0.04930056  0.04930056  0.04930056  0.04930056
      regA_08    -0.06135342 -0.06135342 -0.06135342 -0.06135342 -0.06135342
      regAB_06    0.16611932  0.28204347  0.28204347  0.28204347  0.28204347
      regD_08    -0.06693560 -0.06693560 -0.06693560 -0.06693560 -0.06693560
      reg_no_ABC -0.06376465 -0.06376465 -0.06376465 -0.06376465 -0.06376465
      regC_03     0.04795798  0.04795798 -0.06760341 -0.06760341 -0.06760341
      regC_05     0.16855826  0.16855826  0.05002221 -0.06851384 -0.06851384
      regC_09     0.28161008  0.28161008  0.16671409  0.16671409  0.16671409
      reg_no_C    0.16501551  0.16501551  0.16501551  0.16501551  0.04888918
      regB_08     0.15829485  0.15829485  0.04498429  0.04498429  0.04498429
      reg_no_A   -0.06687758 -0.06687758 -0.06687758 -0.06687758 -0.06687758
      regB_04    -0.06476611 -0.06476611 -0.06476611  0.05130219  0.05130219
      regC_06     0.15962361  0.15962361  0.04633503  0.04633503  0.04633503
      regB_09    -0.06567703 -0.06567703 -0.06567703 -0.06567703 -0.06567703
      reg_no_AB  -0.06772276 -0.06772276 -0.06772276 -0.06772276 -0.06772276
      regC_04    -0.06778509 -0.06778509 -0.06778509 -0.06778509 -0.06778509
      regC_01     0.04734488  0.04734488 -0.06784948 -0.06784948 -0.06784948
      regC        0.04993289  0.04993289 -0.06755627 -0.06755627 -0.06755627
      regB_05     0.05010482  0.05010482  0.05010482  0.05010482  0.05010482
      regB_02     0.05154945  0.05154945  0.05154945  0.16739091  0.16739091
      regB_01     0.04900773  0.04900773  0.04900773  0.16459198  0.16459198
      regB        0.04989415  0.04989415  0.04989415  0.16459334  0.16459334
      regC_02     0.04790636  0.04790636 -0.06642863 -0.06642863 -0.06642863
      regB_03    -0.06364593 -0.06364593 -0.06364593  0.05186392  0.05186392
      regC_07    -0.06681379 -0.06681379 -0.06681379 -0.06681379 -0.06681379
      reg_no_B   -0.06784694 -0.06784694 -0.06784694 -0.06784694 -0.06784694
      regB_07    -0.06851326 -0.06851326 -0.06851326  0.04702343  0.04702343
      regB_06     0.04947548  0.04947548  0.04947548  0.04947548  0.04947548
      regC_08     0.05146310 -0.06684287 -0.06684287 -0.06684287 -0.06684287
      regA_04    -0.06429201  0.05154945  0.05154945  0.05154945  0.05154945
      regA_05    -0.06882001  0.04626362  0.04626362  0.16134726  0.16134726
      regAB       0.05479048  0.17211484  0.17211484  0.17211484  0.17211484
      regA_06     0.04568899  0.15991147  0.15991147  0.15991147  0.04568899
      regAB_02    0.05328011  0.17089626  0.17089626  0.17089626  0.17089626
      regA_07    -0.06390469 -0.06390469 -0.06390469 -0.06390469 -0.06390469
      regAB_04    0.05634842  0.17547828  0.17547828  0.17547828  0.17547828
                        -500        -490        -480        -470        -460
      regA_01     0.04833878  0.04833878  0.04833878  0.04833878  0.04833878
      regA        0.05080429  0.05080429  0.05080429  0.05080429  0.05080429
      regA_02     0.05052155  0.05052155  0.05052155  0.05052155  0.05052155
      regA_03     0.04986114  0.04986114  0.04986114  0.04986114  0.04986114
      regD_04     0.04509498  0.04509498  0.04509498  0.04509498  0.04509498
      regD_06     0.15712910  0.15712910  0.26952473  0.26952473  0.26952473
      regD_02     0.16042022  0.16042022  0.38748352  0.50101517  0.50101517
      regD        0.15702267  0.15702267  0.49640885  0.60953757  0.60953757
      regA_09     0.05187058  0.05187058  0.05187058  0.05187058  0.05187058
      regAB_08    0.04930056  0.04930056  0.04930056  0.04930056  0.04930056
      regA_08    -0.06135342 -0.06135342 -0.06135342 -0.06135342 -0.06135342
      regAB_06    0.28204347  0.28204347  0.28204347  0.28204347  0.28204347
      regD_08    -0.06693560 -0.06693560  0.04670718  0.04670718  0.04670718
      reg_no_ABC -0.06376465 -0.06376465 -0.06376465 -0.06376465 -0.06376465
      regC_03    -0.06760341 -0.06760341 -0.06760341 -0.06760341 -0.06760341
      regC_05    -0.06851384 -0.06851384 -0.06851384 -0.06851384 -0.06851384
      regC_09     0.16671409  0.16671409  0.16671409  0.16671409  0.16671409
      reg_no_C    0.04888918  0.04888918  0.04888918  0.04888918  0.04888918
      regB_08     0.04498429  0.04498429  0.04498429  0.04498429  0.04498429
      reg_no_A   -0.06687758 -0.06687758 -0.06687758 -0.06687758 -0.06687758
      regB_04     0.05130219  0.05130219  0.05130219  0.05130219  0.05130219
      regC_06     0.04633503 -0.06695355 -0.06695355 -0.06695355 -0.06695355
      regB_09    -0.06567703 -0.06567703 -0.06567703 -0.06567703 -0.06567703
      reg_no_AB  -0.06772276 -0.06772276 -0.06772276 -0.06772276  0.04843978
      regC_04    -0.06778509 -0.06778509 -0.06778509 -0.06778509 -0.06778509
      regC_01    -0.06784948 -0.06784948 -0.06784948 -0.06784948 -0.06784948
      regC       -0.06755627 -0.06755627 -0.06755627 -0.06755627 -0.06755627
      regB_05     0.05010482  0.05010482  0.05010482  0.05010482  0.05010482
      regB_02     0.16739091  0.16739091  0.16739091  0.16739091  0.16739091
      regB_01     0.16459198  0.16459198  0.16459198  0.16459198  0.16459198
      regB        0.16459334  0.16459334  0.16459334  0.16459334  0.16459334
      regC_02    -0.06642863 -0.06642863 -0.06642863 -0.06642863 -0.06642863
      regB_03     0.05186392  0.05186392  0.05186392  0.05186392  0.05186392
      regC_07    -0.06681379 -0.06681379  0.04918237  0.04918237  0.04918237
      reg_no_B   -0.06784694 -0.06784694 -0.06784694 -0.06784694 -0.06784694
      regB_07     0.04702343  0.04702343  0.04702343  0.04702343  0.04702343
      regB_06     0.04947548  0.04947548  0.04947548  0.04947548  0.04947548
      regC_08    -0.06684287 -0.06684287 -0.06684287 -0.06684287 -0.06684287
      regA_04     0.05154945  0.05154945  0.05154945  0.05154945  0.05154945
      regA_05     0.16134726  0.16134726  0.16134726  0.16134726  0.16134726
      regAB       0.17211484  0.17211484  0.17211484  0.17211484  0.17211484
      regA_06     0.04568899  0.04568899  0.04568899  0.04568899  0.04568899
      regAB_02    0.17089626  0.17089626  0.17089626  0.17089626  0.17089626
      regA_07    -0.06390469 -0.06390469 -0.06390469 -0.06390469 -0.06390469
      regAB_04    0.17547828  0.17547828  0.17547828  0.17547828  0.17547828
                        -450        -440        -430        -420        -410
      regA_01     0.04833878  0.04833878  0.04833878  0.04833878  0.04833878
      regA        0.05080429  0.05080429  0.05080429  0.05080429  0.05080429
      regA_02     0.05052155  0.05052155  0.05052155  0.05052155  0.05052155
      regA_03     0.04986114  0.04986114  0.04986114  0.04986114  0.04986114
      regD_04     0.15868433  0.38586305  0.84022048  1.18098856  1.40816727
      regD_06     0.38192037  0.60671163  1.05629417  1.28108544  1.39348107
      regD_02     0.61454682  1.06867342  1.63633167  1.86339497  2.09045827
      regD        0.72266630  1.06205247  1.62769610  1.96708227  2.19333972
      regA_09     0.05187058  0.05187058  0.16922483  0.16922483  0.16922483
      regAB_08    0.04930056  0.04930056  0.04930056 -0.06615742 -0.06615742
      regA_08    -0.06135342 -0.06135342 -0.06135342 -0.06135342 -0.06135342
      regAB_06    0.28204347  0.16611932  0.16611932  0.16611932  0.16611932
      regD_08     0.04670718  0.04670718  0.27399274  0.27399274  0.27399274
      reg_no_ABC -0.06376465 -0.06376465 -0.06376465 -0.06376465 -0.06376465
      regC_03    -0.06760341 -0.06760341 -0.06760341 -0.06760341 -0.06760341
      regC_05    -0.06851384 -0.06851384 -0.06851384 -0.06851384 -0.06851384
      regC_09     0.16671409  0.16671409  0.16671409  0.16671409  0.16671409
      reg_no_C    0.04888918  0.04888918  0.04888918 -0.06723714 -0.06723714
      regB_08     0.04498429 -0.06832627 -0.06832627 -0.06832627 -0.06832627
      reg_no_A   -0.06687758 -0.06687758 -0.06687758 -0.06687758 -0.06687758
      regB_04     0.05130219  0.05130219  0.05130219  0.05130219  0.05130219
      regC_06    -0.06695355 -0.06695355 -0.06695355 -0.06695355 -0.06695355
      regB_09    -0.06567703 -0.06567703 -0.06567703  0.05244712  0.05244712
      reg_no_AB   0.04843978  0.04843978  0.04843978  0.04843978  0.04843978
      regC_04    -0.06778509 -0.06778509 -0.06778509 -0.06778509 -0.06778509
      regC_01    -0.06784948 -0.06784948 -0.06784948 -0.06784948 -0.06784948
      regC       -0.06755627 -0.06755627 -0.06755627 -0.06755627 -0.06755627
      regB_05     0.05010482 -0.06614767 -0.06614767 -0.06614767 -0.06614767
      regB_02     0.16739091  0.05154945  0.05154945  0.05154945  0.05154945
      regB_01     0.16459198  0.04900773  0.04900773  0.04900773  0.04900773
      regB        0.16459334  0.04989415  0.04989415  0.04989415  0.04989415
      regC_02    -0.06642863 -0.06642863 -0.06642863 -0.06642863 -0.06642863
      regB_03     0.05186392  0.05186392  0.05186392  0.05186392  0.05186392
      regC_07     0.04918237  0.04918237  0.04918237  0.04918237  0.04918237
      reg_no_B   -0.06784694 -0.06784694 -0.06784694 -0.06784694 -0.06784694
      regB_07     0.04702343  0.04702343  0.04702343  0.04702343  0.04702343
      regB_06     0.04947548 -0.06639216 -0.06639216 -0.06639216 -0.06639216
      regC_08    -0.06684287 -0.06684287 -0.06684287 -0.06684287 -0.06684287
      regA_04     0.05154945  0.05154945  0.05154945  0.05154945  0.05154945
      regA_05     0.16134726  0.16134726  0.16134726  0.16134726  0.16134726
      regAB       0.17211484  0.05479048  0.05479048  0.05479048  0.05479048
      regA_06     0.04568899  0.04568899  0.04568899  0.04568899  0.04568899
      regAB_02    0.28851240  0.17089626  0.17089626  0.17089626  0.17089626
      regA_07    -0.06390469 -0.06390469 -0.06390469 -0.06390469 -0.06390469
      regAB_04    0.17547828  0.05634842  0.05634842  0.05634842  0.17547828
                        -400        -390        -380        -370        -360
      regA_01     0.04833878  0.04833878  0.04833878  0.04833878  0.04833878
      regA        0.05080429  0.05080429  0.05080429  0.05080429  0.05080429
      regA_02     0.05052155  0.05052155  0.05052155  0.05052155  0.05052155
      regA_03     0.04986114  0.04986114  0.04986114  0.04986114  0.04986114
      regD_04     1.52175663  1.63534599  1.63534599  1.63534599  1.86252471
      regD_06     1.39348107  1.50587671  1.61827234  1.61827234  1.73066798
      regD_02     2.31752157  2.43105322  2.88517982  2.99871147  3.11224312
      regD        2.53272590  2.75898335  3.21149825  3.32462697  3.55088442
      regA_09     0.16922483  0.16922483  0.16922483  0.16922483  0.16922483
      regAB_08   -0.06615742 -0.06615742 -0.06615742 -0.06615742 -0.06615742
      regA_08    -0.06135342  0.05289876  0.05289876  0.05289876  0.05289876
      regAB_06    0.16611932  0.16611932  0.16611932  0.16611932  0.16611932
      regD_08     0.27399274  0.27399274  0.50127829  0.50127829  0.61492107
      reg_no_ABC -0.06376465 -0.06376465 -0.06376465 -0.06376465 -0.06376465
      regC_03    -0.06760341 -0.06760341 -0.06760341 -0.06760341 -0.06760341
      regC_05    -0.06851384 -0.06851384  0.05002221  0.05002221  0.05002221
      regC_09     0.16671409  0.16671409  0.05181809  0.05181809  0.05181809
      reg_no_C   -0.06723714 -0.06723714  0.04888918  0.04888918  0.04888918
      regB_08    -0.06832627 -0.06832627 -0.06832627 -0.06832627 -0.06832627
      reg_no_A   -0.06687758 -0.06687758 -0.06687758 -0.06687758 -0.06687758
      regB_04     0.16737049  0.16737049  0.16737049  0.16737049  0.16737049
      regC_06     0.04633503  0.04633503  0.04633503  0.04633503  0.04633503
      regB_09     0.05244712  0.05244712  0.05244712  0.05244712  0.05244712
      reg_no_AB   0.04843978  0.04843978  0.04843978  0.04843978  0.04843978
      regC_04    -0.06778509 -0.06778509 -0.06778509 -0.06778509 -0.06778509
      regC_01    -0.06784948 -0.06784948 -0.06784948 -0.06784948 -0.06784948
      regC       -0.06755627 -0.06755627 -0.06755627 -0.06755627 -0.06755627
      regB_05    -0.06614767 -0.06614767 -0.06614767 -0.06614767 -0.06614767
      regB_02     0.05154945  0.05154945  0.05154945  0.05154945  0.05154945
      regB_01     0.04900773  0.04900773  0.04900773  0.04900773  0.04900773
      regB        0.04989415  0.04989415  0.04989415  0.04989415  0.04989415
      regC_02    -0.06642863 -0.06642863 -0.06642863 -0.06642863 -0.06642863
      regB_03     0.05186392  0.05186392  0.05186392  0.05186392  0.05186392
      regC_07     0.04918237  0.04918237  0.04918237  0.04918237  0.04918237
      reg_no_B   -0.06784694 -0.06784694 -0.06784694 -0.06784694 -0.06784694
      regB_07     0.04702343  0.04702343  0.04702343  0.04702343  0.04702343
      regB_06    -0.06639216 -0.06639216 -0.06639216 -0.06639216 -0.06639216
      regC_08    -0.06684287 -0.06684287 -0.06684287 -0.06684287 -0.06684287
      regA_04     0.05154945  0.05154945  0.05154945  0.05154945  0.05154945
      regA_05     0.16134726  0.16134726  0.16134726  0.16134726  0.04626362
      regAB       0.05479048  0.05479048  0.05479048  0.05479048  0.05479048
      regA_06     0.04568899  0.04568899  0.04568899  0.04568899  0.04568899
      regAB_02    0.17089626  0.28851240  0.28851240  0.28851240  0.28851240
      regA_07    -0.06390469 -0.06390469 -0.06390469 -0.06390469 -0.06390469
      regAB_04    0.17547828  0.17547828  0.17547828  0.17547828  0.17547828
                        -350        -340        -330        -320        -310
      regA_01     0.04833878  0.04833878  0.04833878  0.04833878  0.04833878
      regA        0.05080429  0.05080429  0.05080429  0.05080429  0.05080429
      regA_02     0.05052155  0.05052155  0.05052155  0.05052155  0.05052155
      regA_03     0.04986114  0.04986114  0.04986114  0.04986114  0.04986114
      regD_04     1.97611406  2.08970342  2.43047150  2.54406085  2.65765021
      regD_06     1.95545924  1.95545924  2.06785488  2.18025051  2.18025051
      regD_02     3.33930641  3.56636971  3.79343301  3.90696466  4.02049631
      regD        3.89027060  4.11652805  4.45591422  4.56904295  4.68217167
      regA_09     0.05187058  0.05187058  0.05187058  0.05187058  0.05187058
      regAB_08   -0.06615742 -0.06615742 -0.06615742 -0.06615742 -0.06615742
      regA_08     0.05289876  0.05289876  0.05289876  0.05289876  0.05289876
      regAB_06    0.16611932  0.16611932  0.16611932  0.16611932  0.16611932
      regD_08     0.61492107  0.61492107  0.72856385  0.72856385  0.84220663
      reg_no_ABC -0.06376465 -0.06376465 -0.06376465 -0.06376465 -0.06376465
      regC_03     0.16351936  0.16351936  0.16351936  0.16351936  0.16351936
      regC_05     0.05002221  0.05002221  0.05002221  0.05002221  0.05002221
      regC_09     0.16671409  0.16671409  0.16671409  0.16671409  0.16671409
      reg_no_C    0.04888918  0.04888918  0.04888918  0.04888918  0.04888918
      regB_08    -0.06832627 -0.06832627 -0.06832627 -0.06832627 -0.06832627
      reg_no_A   -0.06687758 -0.06687758 -0.06687758 -0.06687758  0.04571094
      regB_04     0.16737049  0.16737049  0.16737049  0.16737049  0.16737049
      regC_06     0.15962361  0.15962361  0.15962361  0.15962361  0.15962361
      regB_09     0.05244712  0.05244712  0.05244712  0.05244712  0.05244712
      reg_no_AB   0.04843978  0.04843978  0.04843978  0.04843978  0.04843978
      regC_04     0.16515337  0.16515337  0.16515337  0.16515337  0.16515337
      regC_01     0.16253925  0.16253925  0.16253925  0.16253925  0.16253925
      regC        0.16742206  0.16742206  0.16742206  0.16742206  0.16742206
      regB_05    -0.06614767  0.05010482  0.05010482  0.05010482  0.05010482
      regB_02     0.05154945  0.05154945  0.05154945  0.05154945  0.05154945
      regB_01     0.04900773  0.04900773  0.04900773  0.04900773  0.04900773
      regB        0.04989415  0.04989415  0.04989415  0.04989415  0.04989415
      regC_02     0.04790636  0.04790636  0.04790636  0.04790636  0.04790636
      regB_03     0.05186392  0.05186392  0.05186392  0.05186392  0.05186392
      regC_07     0.04918237  0.04918237  0.04918237  0.04918237  0.04918237
      reg_no_B   -0.06784694 -0.06784694 -0.06784694 -0.06784694 -0.06784694
      regB_07     0.04702343  0.04702343  0.04702343  0.04702343  0.04702343
      regB_06    -0.06639216 -0.06639216 -0.06639216 -0.06639216 -0.06639216
      regC_08    -0.06684287 -0.06684287 -0.06684287 -0.06684287 -0.06684287
      regA_04     0.05154945  0.05154945  0.05154945  0.05154945  0.05154945
      regA_05     0.04626362  0.04626362  0.04626362  0.04626362  0.04626362
      regAB       0.05479048  0.05479048  0.05479048  0.05479048  0.05479048
      regA_06     0.04568899  0.04568899  0.04568899  0.04568899  0.04568899
      regAB_02    0.28851240  0.28851240  0.28851240  0.28851240  0.28851240
      regA_07    -0.06390469 -0.06390469 -0.06390469 -0.06390469 -0.06390469
      regAB_04    0.17547828  0.17547828  0.17547828  0.17547828  0.17547828
                        -300        -290        -280        -270        -260
      regA_01     0.04833878 -0.06566777 -0.06566777 -0.06566777 -0.06566777
      regA        0.05080429 -0.06518724 -0.06518724 -0.06518724 -0.06518724
      regA_02     0.05052155 -0.06403979 -0.06403979 -0.06403979 -0.06403979
      regA_03     0.04986114 -0.06555817 -0.06555817 -0.06555817 -0.06555817
      regD_04     2.77123957  2.65765021  2.54406085  2.43047150  2.08970342
      regD_06     2.18025051  2.18025051  2.18025051  2.18025051  2.06785488
      regD_02     4.24755961  4.02049631  3.90696466  3.79343301  3.56636971
      regD        4.90842912  4.68217167  4.56904295  4.45591422  4.11652805
      regA_09     0.05187058  0.05187058  0.05187058  0.05187058  0.05187058
      regAB_08   -0.06615742 -0.06615742 -0.06615742 -0.06615742 -0.06615742
      regA_08     0.05289876  0.05289876  0.05289876  0.05289876  0.05289876
      regAB_06    0.16611932  0.05019516 -0.06572900 -0.06572900 -0.06572900
      regD_08     0.84220663  0.84220663  0.72856385  0.72856385  0.61492107
      reg_no_ABC -0.06376465 -0.06376465 -0.06376465 -0.06376465 -0.06376465
      regC_03     0.16351936  0.16351936  0.16351936  0.16351936  0.16351936
      regC_05     0.05002221  0.05002221  0.05002221  0.05002221  0.05002221
      regC_09     0.28161008  0.28161008  0.28161008  0.28161008  0.28161008
      reg_no_C    0.04888918  0.04888918  0.16501551  0.16501551  0.16501551
      regB_08    -0.06832627 -0.06832627 -0.06832627 -0.06832627 -0.06832627
      reg_no_A    0.04571094  0.15829946  0.15829946  0.15829946  0.15829946
      regB_04     0.16737049  0.16737049  0.16737049  0.05130219  0.05130219
      regC_06     0.15962361  0.15962361  0.15962361  0.15962361  0.15962361
      regB_09     0.05244712  0.05244712  0.05244712  0.05244712  0.05244712
      reg_no_AB   0.04843978  0.04843978  0.04843978  0.04843978  0.04843978
      regC_04     0.16515337  0.16515337  0.16515337  0.16515337  0.16515337
      regC_01     0.16253925  0.16253925  0.16253925  0.16253925  0.16253925
      regC        0.16742206  0.16742206  0.16742206  0.16742206  0.16742206
      regB_05     0.05010482  0.05010482  0.05010482  0.05010482  0.05010482
      regB_02     0.05154945  0.16739091  0.16739091  0.05154945  0.05154945
      regB_01     0.04900773  0.04900773  0.04900773 -0.06657653 -0.06657653
      regB        0.04989415  0.04989415  0.04989415 -0.06480504 -0.06480504
      regC_02     0.04790636  0.04790636  0.04790636  0.04790636  0.04790636
      regB_03     0.05186392  0.05186392  0.05186392 -0.06364593 -0.06364593
      regC_07     0.04918237  0.04918237  0.04918237  0.04918237  0.04918237
      reg_no_B   -0.06784694 -0.06784694 -0.06784694 -0.06784694 -0.06784694
      regB_07     0.04702343  0.04702343  0.04702343 -0.06851326 -0.06851326
      regB_06    -0.06639216 -0.06639216 -0.06639216 -0.06639216 -0.06639216
      regC_08    -0.06684287 -0.06684287 -0.06684287 -0.06684287 -0.06684287
      regA_04     0.05154945 -0.06429201 -0.06429201 -0.06429201 -0.06429201
      regA_05     0.04626362 -0.06882001 -0.06882001 -0.06882001 -0.06882001
      regAB       0.05479048 -0.06253388 -0.06253388 -0.06253388 -0.06253388
      regA_06     0.04568899 -0.06853349 -0.06853349 -0.06853349 -0.06853349
      regAB_02    0.28851240  0.17089626  0.17089626  0.17089626  0.17089626
      regA_07    -0.06390469 -0.06390469 -0.06390469 -0.06390469 -0.06390469
      regAB_04    0.17547828  0.05634842  0.05634842  0.05634842  0.05634842
                        -250        -240        -230        -220        -210
      regA_01    -0.06566777 -0.06566777  0.04833878  0.16234533  0.27635187
      regA       -0.06518724 -0.06518724  0.05080429  0.16679582  0.28278735
      regA_02    -0.06403979 -0.06403979  0.05052155  0.05052155  0.27964425
      regA_03    -0.06555817 -0.06555817  0.04986114  0.16528046  0.28069978
      regD_04     1.97611406  1.86252471  1.74893535  1.74893535  1.74893535
      regD_06     2.06785488  1.95545924  1.84306361  1.84306361  1.73066798
      regD_02     3.33930641  3.11224312  3.11224312  2.99871147  2.54458487
      regD        3.89027060  3.55088442  3.43775570  3.32462697  2.87211207
      regA_09     0.05187058  0.05187058  0.05187058  0.05187058  0.16922483
      regAB_08   -0.06615742 -0.06615742 -0.06615742 -0.06615742 -0.06615742
      regA_08     0.05289876  0.05289876  0.05289876  0.05289876  0.05289876
      regAB_06   -0.06572900 -0.06572900 -0.06572900 -0.06572900 -0.06572900
      regD_08     0.61492107  0.61492107  0.50127829  0.50127829  0.38763552
      reg_no_ABC -0.06376465 -0.06376465 -0.06376465 -0.06376465 -0.06376465
      regC_03     0.16351936  0.16351936  0.16351936  0.16351936  0.16351936
      regC_05     0.05002221  0.05002221  0.05002221  0.05002221  0.05002221
      regC_09     0.28161008  0.28161008  0.28161008  0.28161008  0.28161008
      reg_no_C    0.16501551  0.16501551  0.16501551  0.16501551  0.16501551
      regB_08    -0.06832627 -0.06832627 -0.06832627 -0.06832627 -0.06832627
      reg_no_A    0.15829946  0.15829946  0.15829946  0.15829946  0.15829946
      regB_04    -0.06476611 -0.06476611 -0.06476611 -0.06476611 -0.06476611
      regC_06     0.15962361  0.15962361  0.15962361  0.15962361  0.15962361
      regB_09    -0.06567703  0.05244712  0.05244712  0.05244712  0.05244712
      reg_no_AB   0.04843978  0.04843978  0.04843978  0.04843978  0.04843978
      regC_04     0.16515337  0.16515337  0.16515337  0.16515337  0.16515337
      regC_01     0.16253925  0.16253925  0.16253925  0.16253925  0.16253925
      regC        0.16742206  0.16742206  0.16742206  0.16742206  0.16742206
      regB_05    -0.06614767 -0.06614767 -0.06614767 -0.06614767 -0.06614767
      regB_02     0.05154945  0.05154945  0.05154945  0.05154945  0.05154945
      regB_01    -0.06657653 -0.06657653 -0.06657653 -0.06657653 -0.06657653
      regB       -0.06480504 -0.06480504 -0.06480504 -0.06480504 -0.06480504
      regC_02     0.04790636  0.04790636  0.04790636  0.04790636  0.04790636
      regB_03    -0.06364593 -0.06364593 -0.06364593 -0.06364593 -0.06364593
      regC_07     0.04918237  0.04918237  0.04918237  0.04918237  0.04918237
      reg_no_B   -0.06784694 -0.06784694 -0.06784694 -0.06784694 -0.06784694
      regB_07    -0.06851326 -0.06851326 -0.06851326 -0.06851326 -0.06851326
      regB_06    -0.06639216 -0.06639216 -0.06639216 -0.06639216 -0.06639216
      regC_08    -0.06684287 -0.06684287 -0.06684287 -0.06684287 -0.06684287
      regA_04    -0.06429201 -0.06429201 -0.06429201 -0.06429201 -0.06429201
      regA_05    -0.06882001 -0.06882001  0.04626362  0.04626362  0.16134726
      regAB      -0.06253388 -0.06253388 -0.06253388 -0.06253388 -0.06253388
      regA_06    -0.06853349 -0.06853349 -0.06853349 -0.06853349 -0.06853349
      regAB_02    0.05328011  0.05328011  0.05328011  0.05328011  0.05328011
      regA_07    -0.06390469 -0.06390469 -0.06390469 -0.06390469 -0.06390469
      regAB_04    0.05634842  0.05634842  0.05634842  0.05634842  0.05634842
                        -200        -190        -180        -170        -160
      regA_01     0.27635187  0.39035842  1.07439771  1.41641736  1.64443046
      regA        0.28278735  0.39877888  1.21071960  1.67468573  1.90666879
      regA_02     0.27964425  0.39420559  1.19613502  1.31069636  1.53981906
      regA_03     0.28069978  0.39611909  0.97321567  1.31947362  1.31947362
      regD_04     1.63534599  1.52175663  1.29457792  0.95380984  0.49945241
      regD_06     1.61827234  1.61827234  1.50587671  1.39348107  0.94389854
      regD_02     2.43105322  2.20398992  1.97692662  1.63633167  1.06867342
      regD        2.64585462  2.30646845  2.08021100  1.74082482  1.17518120
      regA_09     0.16922483  0.28657908  0.40393332  0.40393332  0.40393332
      regAB_08   -0.06615742 -0.06615742 -0.06615742  0.04930056  0.04930056
      regA_08     0.05289876  0.05289876  0.16715094  0.28140312  0.39565531
      regAB_06   -0.06572900  0.05019516  0.16611932  0.16611932  0.16611932
      regD_08     0.38763552  0.38763552  0.38763552  0.38763552  0.16034996
      reg_no_ABC -0.06376465 -0.06376465 -0.06376465 -0.06376465 -0.06376465
      regC_03     0.16351936  0.16351936  0.16351936  0.04795798  0.16351936
      regC_05     0.05002221  0.05002221  0.05002221  0.05002221  0.05002221
      regC_09     0.16671409  0.05181809  0.05181809  0.05181809  0.05181809
      reg_no_C    0.16501551  0.16501551  0.16501551  0.16501551  0.16501551
      regB_08    -0.06832627 -0.06832627 -0.06832627 -0.06832627 -0.06832627
      reg_no_A    0.15829946  0.15829946  0.15829946  0.15829946  0.15829946
      regB_04    -0.06476611 -0.06476611 -0.06476611 -0.06476611 -0.06476611
      regC_06     0.15962361  0.15962361  0.04633503 -0.06695355 -0.06695355
      regB_09     0.05244712  0.05244712  0.05244712  0.05244712  0.05244712
      reg_no_AB   0.04843978  0.04843978  0.04843978  0.04843978  0.04843978
      regC_04     0.16515337  0.16515337  0.16515337  0.04868414  0.04868414
      regC_01     0.16253925  0.16253925  0.16253925  0.04734488  0.04734488
      regC        0.16742206  0.16742206  0.16742206  0.04993289  0.04993289
      regB_05    -0.06614767 -0.06614767 -0.06614767 -0.06614767 -0.06614767
      regB_02     0.05154945  0.05154945  0.05154945  0.05154945  0.05154945
      regB_01    -0.06657653 -0.06657653 -0.06657653 -0.06657653 -0.06657653
      regB       -0.06480504 -0.06480504 -0.06480504 -0.06480504 -0.06480504
      regC_02     0.04790636  0.04790636  0.04790636 -0.06642863 -0.06642863
      regB_03    -0.06364593 -0.06364593 -0.06364593 -0.06364593 -0.06364593
      regC_07     0.04918237  0.04918237  0.04918237  0.04918237  0.04918237
      reg_no_B   -0.06784694 -0.06784694 -0.06784694  0.04872856  0.04872856
      regB_07    -0.06851326 -0.06851326 -0.06851326 -0.06851326 -0.06851326
      regB_06    -0.06639216 -0.06639216 -0.06639216 -0.06639216 -0.06639216
      regC_08    -0.06684287 -0.06684287 -0.06684287 -0.06684287 -0.06684287
      regA_04    -0.06429201  0.05154945  0.51491529  0.74659820  0.74659820
      regA_05     0.16134726  0.27643089  0.62168180  0.73676543  0.73676543
      regAB      -0.06253388  0.05479048  0.64141227  0.99338535  0.99338535
      regA_06    -0.06853349 -0.06853349  0.38835642  0.73102384  0.95946880
      regAB_02    0.05328011  0.17089626  0.75897697  0.87659311  0.87659311
      regA_07    -0.06390469  0.05103180  0.28090479  0.51077778  0.62571427
      regAB_04    0.05634842  0.05634842  0.29460814  0.41373799  0.41373799
                        -150        -140        -130        -120        -110
      regA_01     1.87244355  2.44247630  3.69654833  4.49459417  5.29264001
      regA        2.13865186  2.71860951  3.99451636  4.80645708  5.61839780
      regA_02     1.65438040  1.99806444  3.02911656  3.60192329  4.28929137
      regA_03     1.43489293  2.01198951  3.05076335  3.39702130  3.85869856
      regD_04     0.27227369  0.15868433  0.15868433  0.15868433  0.15868433
      regD_06     0.71910727  0.60671163  0.60671163  0.60671163  0.38192037
      regD_02     0.72807847  0.61454682  0.61454682  0.50101517  0.27395187
      regD        0.83579502  0.72266630  0.72266630  0.60953757  0.27015140
      regA_09     0.40393332  0.40393332  0.52128757  0.52128757  0.52128757
      regAB_08    0.04930056  0.04930056  0.04930056  0.04930056  0.04930056
      regA_08     0.39565531  0.39565531  0.85266404  0.85266404  0.96691622
      regAB_06    0.28204347  0.51389178  0.86166425  0.86166425  1.09351257
      regD_08     0.16034996  0.16034996  0.16034996  0.16034996  0.04670718
      reg_no_ABC -0.06376465 -0.06376465 -0.06376465 -0.06376465 -0.06376465
      regC_03     0.16351936  0.16351936  0.16351936  0.04795798  0.04795798
      regC_05     0.05002221  0.05002221  0.05002221  0.05002221 -0.06851384
      regC_09     0.05181809  0.05181809  0.05181809 -0.06307790 -0.06307790
      reg_no_C    0.16501551  0.16501551  0.16501551  0.04888918  0.04888918
      regB_08    -0.06832627 -0.06832627  0.04498429  0.04498429  0.04498429
      reg_no_A    0.15829946  0.15829946  0.15829946  0.15829946  0.04571094
      regB_04    -0.06476611 -0.06476611 -0.06476611 -0.06476611 -0.06476611
      regC_06    -0.06695355 -0.06695355 -0.06695355 -0.06695355 -0.06695355
      regB_09     0.17057127  0.17057127  0.05244712  0.05244712  0.05244712
      reg_no_AB   0.04843978  0.04843978  0.04843978  0.04843978  0.04843978
      regC_04     0.04868414  0.04868414  0.04868414 -0.06778509 -0.06778509
      regC_01     0.04734488  0.04734488  0.04734488 -0.06784948 -0.06784948
      regC        0.04993289  0.04993289  0.04993289 -0.06755627 -0.06755627
      regB_05    -0.06614767 -0.06614767 -0.06614767 -0.06614767 -0.06614767
      regB_02     0.05154945 -0.06429201 -0.06429201 -0.06429201 -0.06429201
      regB_01    -0.06657653 -0.06657653 -0.06657653 -0.06657653 -0.06657653
      regB       -0.06480504 -0.06480504 -0.06480504 -0.06480504 -0.06480504
      regC_02    -0.06642863 -0.06642863 -0.06642863 -0.06642863 -0.06642863
      regB_03    -0.06364593 -0.06364593 -0.06364593 -0.06364593 -0.06364593
      regC_07     0.04918237  0.04918237  0.04918237 -0.06681379 -0.06681379
      reg_no_B    0.04872856  0.04872856  0.04872856  0.04872856  0.04872856
      regB_07    -0.06851326 -0.06851326  0.04702343  0.04702343  0.04702343
      regB_06    -0.06639216 -0.06639216 -0.06639216 -0.06639216 -0.06639216
      regC_08    -0.06684287 -0.06684287 -0.06684287 -0.06684287 -0.06684287
      regA_04     0.86243966  1.44164696  2.25253717  2.71590301  3.06342739
      regA_05     0.85184907  1.19709997  1.88760178  2.46301996  3.03843813
      regAB       1.22803407  1.58000715  2.04930458  2.40127766  2.87057510
      regA_06     1.07369127  1.30213622  1.87324860  2.21591603  2.67280593
      regAB_02    0.99420926  1.34705768  1.81752226  2.05275454  2.40560297
      regA_07     0.74065077  0.85558726  1.20039674  1.43026973  1.77507921
      regAB_04    0.65199771  0.89025742  1.24764699  1.48590670  1.96242613
                        -100         -90         -80         -70         -60
      regA_01     5.86267276  6.54671205  7.23075134  7.80078408  8.02879718
      regA        6.19835545  6.89430464  7.70624536  8.28620302  8.75016914
      regA_02     4.74753676  5.43490484  6.12227291  6.69507965  7.03876369
      regA_03     4.32037583  4.89747241  5.24373035  5.58998830  5.93624625
      regD_04     0.15868433  0.15868433  0.04509498  0.04509498  0.04509498
      regD_06     0.38192037  0.38192037  0.38192037  0.38192037  0.26952473
      regD_02     0.27395187  0.27395187  0.16042022  0.16042022  0.04688857
      regD        0.27015140  0.27015140  0.15702267  0.15702267  0.04389395
      regA_09     0.87335032  0.87335032  0.99070457  0.99070457  1.10805882
      regAB_08    0.39567448  0.51113245  0.62659043  0.85750638  0.85750638
      regA_08     0.96691622  1.08116840  1.08116840  1.19542058  1.42392495
      regAB_06    1.20943672  1.32536088  1.55720919  1.67313335  1.67313335
      regD_08     0.04670718  0.04670718  0.04670718  0.04670718  0.04670718
      reg_no_ABC -0.06376465 -0.06376465 -0.06376465 -0.06376465 -0.06376465
      regC_03     0.04795798  0.04795798  0.04795798  0.04795798  0.04795798
      regC_05    -0.06851384 -0.06851384 -0.06851384 -0.06851384 -0.06851384
      regC_09    -0.06307790 -0.06307790 -0.06307790 -0.06307790 -0.06307790
      reg_no_C    0.04888918  0.04888918 -0.06723714 -0.06723714  0.04888918
      regB_08     0.04498429  0.04498429  0.04498429  0.04498429  0.04498429
      reg_no_A    0.04571094  0.04571094  0.04571094 -0.06687758 -0.06687758
      regB_04    -0.06476611 -0.06476611 -0.06476611 -0.06476611 -0.06476611
      regC_06    -0.06695355 -0.06695355 -0.06695355 -0.06695355 -0.06695355
      regB_09     0.05244712  0.05244712  0.05244712  0.05244712  0.05244712
      reg_no_AB   0.04843978  0.04843978  0.04843978  0.04843978  0.04843978
      regC_04    -0.06778509 -0.06778509 -0.06778509 -0.06778509 -0.06778509
      regC_01    -0.06784948 -0.06784948 -0.06784948 -0.06784948 -0.06784948
      regC       -0.06755627 -0.06755627 -0.06755627 -0.06755627 -0.06755627
      regB_05    -0.06614767 -0.06614767 -0.06614767 -0.06614767  0.05010482
      regB_02    -0.06429201 -0.06429201 -0.06429201 -0.06429201  0.05154945
      regB_01    -0.06657653 -0.06657653 -0.06657653 -0.06657653 -0.06657653
      regB       -0.06480504 -0.06480504 -0.06480504 -0.06480504  0.04989415
      regC_02    -0.06642863 -0.06642863 -0.06642863 -0.06642863 -0.06642863
      regB_03    -0.06364593 -0.06364593 -0.06364593 -0.06364593 -0.06364593
      regC_07    -0.06681379 -0.06681379 -0.06681379 -0.06681379 -0.06681379
      reg_no_B    0.04872856  0.04872856  0.04872856  0.04872856  0.04872856
      regB_07     0.04702343  0.04702343  0.04702343  0.04702343  0.04702343
      regB_06    -0.06639216 -0.06639216 -0.06639216 -0.06639216  0.04947548
      regC_08    -0.06684287 -0.06684287 -0.06684287 -0.06684287 -0.06684287
      regA_04     3.64263468  4.22184198  4.68520781  4.80104927  5.26441511
      regA_05     3.38368904  3.72893994  4.18927448  4.64960902  4.76469266
      regAB       3.22254818  3.45719689  3.80916997  4.16114305  4.51311613
      regA_06     2.90125088  3.12969583  3.24391831  3.24391831  3.35814078
      regAB_02    2.64083526  2.87606754  2.99368368  3.22891597  3.69938054
      regA_07     2.11988869  2.46469817  2.80950765  2.92444415  3.03938064
      regAB_04    2.08155598  2.31981570  2.67720527  3.03459484  3.15372469
                         -50         -40         -30         -20         -10
      regA_01     8.37081682  8.82684302  9.28286921  9.39687576  9.62488886
      regA        9.33012680  9.79409293 10.25805905 10.37405058 10.72202518
      regA_02     7.38244772  7.72613176  8.18437715  8.29893850  8.64262254
      regA_03     6.51334283  6.74418146  6.97502009  7.09043940  7.32127804
      regD_04     0.04509498  0.04509498  0.04509498  0.04509498  0.04509498
      regD_06     0.26952473  0.26952473  0.15712910  0.15712910  0.15712910
      regD_02     0.04688857  0.04688857  0.04688857  0.04688857  0.04688857
      regD        0.04389395  0.04389395  0.04389395  0.04389395  0.04389395
      regA_09     0.99070457  0.99070457  1.10805882  1.10805882  1.10805882
      regAB_08    0.85750638  0.85750638  0.85750638  0.85750638  0.85750638
      regA_08     1.53817713  1.65242931  1.88093367  1.99518586  2.22369022
      regAB_06    1.78905750  1.78905750  1.78905750  1.78905750  1.90498166
      regD_08     0.04670718  0.04670718  0.04670718  0.16034996  0.16034996
      reg_no_ABC -0.06376465 -0.06376465 -0.06376465 -0.06376465 -0.06376465
      regC_03     0.04795798  0.04795798 -0.06760341 -0.06760341 -0.06760341
      regC_05    -0.06851384 -0.06851384 -0.06851384 -0.06851384 -0.06851384
      regC_09    -0.06307790 -0.06307790 -0.06307790 -0.06307790 -0.06307790
      reg_no_C    0.04888918  0.04888918  0.04888918  0.04888918  0.04888918
      regB_08     0.04498429  0.04498429  0.04498429  0.04498429  0.04498429
      reg_no_A   -0.06687758 -0.06687758  0.04571094  0.04571094  0.04571094
      regB_04    -0.06476611 -0.06476611 -0.06476611 -0.06476611 -0.06476611
      regC_06    -0.06695355 -0.06695355 -0.06695355 -0.06695355 -0.06695355
      regB_09     0.05244712  0.05244712  0.05244712 -0.06567703 -0.06567703
      reg_no_AB   0.04843978  0.04843978  0.04843978  0.04843978  0.04843978
      regC_04    -0.06778509 -0.06778509 -0.06778509 -0.06778509 -0.06778509
      regC_01    -0.06784948 -0.06784948 -0.06784948 -0.06784948 -0.06784948
      regC       -0.06755627 -0.06755627 -0.06755627 -0.06755627 -0.06755627
      regB_05     0.05010482  0.05010482  0.05010482  0.05010482  0.05010482
      regB_02     0.05154945  0.05154945  0.05154945  0.05154945  0.05154945
      regB_01    -0.06657653 -0.06657653 -0.06657653 -0.06657653 -0.06657653
      regB        0.04989415  0.04989415  0.04989415  0.04989415  0.04989415
      regC_02    -0.06642863 -0.06642863 -0.06642863 -0.06642863 -0.06642863
      regB_03    -0.06364593 -0.06364593 -0.06364593 -0.06364593 -0.06364593
      regC_07    -0.06681379  0.04918237  0.04918237  0.04918237  0.04918237
      reg_no_B    0.04872856  0.04872856  0.04872856  0.04872856  0.04872856
      regB_07     0.04702343  0.04702343  0.04702343  0.04702343  0.04702343
      regB_06     0.04947548  0.04947548  0.04947548  0.04947548  0.04947548
      regC_08    -0.06684287 -0.06684287 -0.06684287 -0.06684287 -0.06684287
      regA_04     5.49609803  5.95946386  6.19114678  6.30698824  6.53867116
      regA_05     4.99485993  4.99485993  5.10994356  5.10994356  5.22502720
      regAB       4.86508921  4.98241357  5.09973792  5.09973792  5.21706228
      regA_06     3.58658573  3.81503069  4.04347564  4.04347564  4.27192059
      regAB_02    3.93461283  4.05222897  4.16984511  4.16984511  4.28746126
      regA_07     3.03938064  3.03938064  3.03938064  3.03938064  3.26925363
      regAB_04    3.39198441  3.63024412  3.63024412  3.63024412  3.63024412
                           0          10          20          30          40
      regA_01    10.19492160  9.62488886  9.39687576  9.28286921  8.82684302
      regA       11.53396590 10.72202518 10.37405058 10.25805905  9.79409293
      regA_02     9.10086792  8.64262254  8.29893850  8.18437715  7.72613176
      regA_03     8.01379393  7.32127804  7.09043940  6.97502009  6.74418146
      regD_04     0.15868433  0.04509498  0.04509498  0.04509498  0.04509498
      regD_06     0.15712910  0.04473346  0.04473346  0.04473346  0.04473346
      regD_02     0.16042022  0.04688857  0.04688857  0.04688857  0.04688857
      regD        0.15702267  0.04389395  0.04389395  0.04389395  0.04389395
      regA_09     1.10805882  1.10805882  1.10805882  1.10805882  0.99070457
      regAB_08    1.08842232  0.85750638  0.85750638  0.85750638  0.85750638
      regA_08     2.33794240  2.22369022  1.99518586  1.88093367  1.65242931
      regAB_06    2.02090582  1.90498166  1.78905750  1.78905750  1.78905750
      regD_08     0.27399274  0.27399274  0.27399274  0.16034996  0.16034996
      reg_no_ABC  0.05175102  0.05175102  0.05175102  0.05175102  0.05175102
      regC_03    -0.06760341 -0.06760341 -0.06760341 -0.06760341 -0.06760341
      regC_05    -0.06851384 -0.06851384 -0.06851384 -0.06851384 -0.06851384
      regC_09    -0.06307790 -0.06307790 -0.06307790 -0.06307790 -0.06307790
      reg_no_C    0.04888918  0.04888918  0.04888918  0.04888918  0.04888918
      regB_08     0.04498429  0.04498429  0.04498429  0.04498429  0.15829485
      reg_no_A    0.04571094  0.04571094  0.04571094  0.04571094  0.04571094
      regB_04    -0.06476611 -0.06476611 -0.06476611 -0.06476611 -0.06476611
      regC_06    -0.06695355 -0.06695355 -0.06695355 -0.06695355 -0.06695355
      regB_09    -0.06567703 -0.06567703 -0.06567703 -0.06567703 -0.06567703
      reg_no_AB   0.04843978  0.04843978  0.04843978  0.04843978  0.04843978
      regC_04    -0.06778509 -0.06778509 -0.06778509 -0.06778509 -0.06778509
      regC_01    -0.06784948 -0.06784948 -0.06784948 -0.06784948 -0.06784948
      regC       -0.06755627 -0.06755627 -0.06755627 -0.06755627 -0.06755627
      regB_05     0.05010482  0.05010482  0.05010482  0.05010482  0.05010482
      regB_02     0.05154945  0.05154945  0.05154945  0.05154945  0.05154945
      regB_01    -0.06657653 -0.06657653 -0.06657653 -0.06657653 -0.06657653
      regB        0.04989415  0.04989415  0.04989415  0.04989415  0.04989415
      regC_02    -0.06642863  0.04790636  0.04790636  0.04790636  0.04790636
      regB_03    -0.06364593 -0.06364593 -0.06364593 -0.06364593 -0.06364593
      regC_07     0.04918237  0.04918237  0.04918237  0.04918237  0.04918237
      reg_no_B    0.04872856  0.04872856  0.04872856  0.04872856  0.04872856
      regB_07     0.04702343  0.04702343  0.04702343  0.04702343  0.04702343
      regB_06     0.04947548  0.04947548  0.04947548  0.04947548  0.04947548
      regC_08    -0.06684287 -0.06684287 -0.06684287 -0.06684287 -0.06684287
      regA_04     6.88619554  6.53867116  6.30698824  6.19114678  5.95946386
      regA_05     5.68536174  5.22502720  5.10994356  5.10994356  4.99485993
      regAB       5.80368408  5.21706228  5.09973792  5.09973792  4.98241357
      regA_06     4.61458801  4.27192059  4.04347564  4.04347564  3.81503069
      regAB_02    4.87554197  4.28746126  4.16984511  4.16984511  4.05222897
      regA_07     3.49912661  3.26925363  3.15431713  3.15431713  3.15431713
      regAB_04    3.86850383  3.63024412  3.51111426  3.51111426  3.51111426
                          50          60          70          80          90
      regA_01     8.37081682  8.02879718  7.80078408  7.23075134  6.54671205
      regA        9.33012680  8.75016914  8.28620302  7.70624536  6.89430464
      regA_02     7.38244772  7.03876369  6.69507965  6.12227291  5.43490484
      regA_03     6.51334283  5.93624625  5.58998830  5.24373035  4.89747241
      regD_04     0.04509498  0.04509498  0.04509498  0.15868433  0.15868433
      regD_06     0.04473346  0.04473346  0.04473346  0.15712910  0.15712910
      regD_02     0.04688857  0.04688857  0.04688857  0.16042022  0.16042022
      regD        0.04389395  0.04389395  0.04389395  0.15702267  0.15702267
      regA_09     0.87335032  0.87335032  0.75599607  0.75599607  0.75599607
      regAB_08    0.85750638  0.85750638  0.85750638  0.62659043  0.51113245
      regA_08     1.42392495  1.30967276  1.08116840  0.96691622  0.96691622
      regAB_06    1.78905750  1.67313335  1.67313335  1.55720919  1.32536088
      regD_08     0.16034996  0.16034996  0.04670718  0.04670718  0.04670718
      reg_no_ABC  0.05175102  0.05175102  0.05175102  0.05175102 -0.06376465
      regC_03    -0.06760341 -0.06760341 -0.06760341 -0.06760341 -0.06760341
      regC_05    -0.06851384 -0.06851384 -0.06851384 -0.06851384 -0.06851384
      regC_09    -0.06307790 -0.06307790 -0.06307790 -0.06307790 -0.06307790
      reg_no_C    0.04888918  0.04888918  0.04888918  0.04888918  0.04888918
      regB_08     0.15829485  0.15829485  0.15829485  0.15829485  0.15829485
      reg_no_A    0.04571094  0.04571094  0.04571094  0.04571094  0.04571094
      regB_04    -0.06476611 -0.06476611 -0.06476611 -0.06476611 -0.06476611
      regC_06    -0.06695355 -0.06695355 -0.06695355 -0.06695355 -0.06695355
      regB_09    -0.06567703 -0.06567703 -0.06567703 -0.06567703 -0.06567703
      reg_no_AB   0.04843978  0.04843978  0.04843978  0.04843978  0.04843978
      regC_04    -0.06778509 -0.06778509 -0.06778509 -0.06778509 -0.06778509
      regC_01    -0.06784948 -0.06784948 -0.06784948 -0.06784948 -0.06784948
      regC       -0.06755627 -0.06755627 -0.06755627 -0.06755627 -0.06755627
      regB_05    -0.06614767 -0.06614767 -0.06614767 -0.06614767 -0.06614767
      regB_02    -0.06429201 -0.06429201 -0.06429201 -0.06429201 -0.06429201
      regB_01    -0.06657653 -0.06657653 -0.06657653 -0.06657653 -0.06657653
      regB       -0.06480504 -0.06480504 -0.06480504 -0.06480504 -0.06480504
      regC_02     0.04790636  0.04790636  0.04790636  0.04790636  0.04790636
      regB_03    -0.06364593  0.05186392  0.05186392  0.05186392  0.05186392
      regC_07     0.04918237  0.04918237  0.04918237  0.04918237  0.04918237
      reg_no_B    0.04872856  0.16530405  0.16530405  0.16530405  0.16530405
      regB_07     0.04702343  0.04702343  0.04702343  0.04702343  0.04702343
      regB_06    -0.06639216 -0.06639216 -0.06639216 -0.06639216  0.04947548
      regC_08    -0.06684287 -0.06684287 -0.06684287 -0.06684287 -0.06684287
      regA_04     5.49609803  5.26441511  4.80104927  4.68520781  4.22184198
      regA_05     4.99485993  4.76469266  4.64960902  4.18927448  3.72893994
      regAB       4.86508921  4.51311613  4.16114305  3.80916997  3.45719689
      regA_06     3.47236326  3.24391831  3.12969583  3.12969583  3.01547336
      regAB_02    3.81699668  3.58176440  3.22891597  2.99368368  2.87606754
      regA_07     3.15431713  3.15431713  3.03938064  2.92444415  2.57963466
      regAB_04    3.39198441  3.15372469  3.03459484  2.67720527  2.31981570
                         100         110         120         130         140
      regA_01     5.86267276  5.29264001  4.49459417  3.69654833  2.44247630
      regA        6.19835545  5.61839780  4.80645708  3.99451636  2.71860951
      regA_02     4.74753676  4.28929137  3.60192329  2.91455521  1.88350310
      regA_03     4.32037583  3.85869856  3.39702130  3.05076335  2.01198951
      regD_04     0.15868433  0.27227369  0.38586305  0.49945241  0.49945241
      regD_06     0.15712910  0.15712910  0.38192037  0.49431600  0.49431600
      regD_02     0.16042022  0.16042022  0.38748352  0.61454682  0.84161012
      regD        0.15702267  0.27015140  0.60953757  0.94892375  1.17518120
      regA_09     0.75599607  0.40393332  0.40393332  0.40393332  0.28657908
      regAB_08    0.39567448  0.04930056  0.04930056  0.16475853  0.16475853
      regA_08     0.85266404  0.85266404  0.73841185  0.73841185  0.28140312
      regAB_06    1.20943672  1.09351257  0.86166425  0.86166425  0.51389178
      regD_08     0.04670718  0.04670718  0.16034996  0.16034996  0.16034996
      reg_no_ABC -0.06376465 -0.06376465 -0.06376465 -0.06376465 -0.06376465
      regC_03    -0.06760341 -0.06760341 -0.06760341 -0.06760341 -0.06760341
      regC_05    -0.06851384 -0.06851384 -0.06851384 -0.06851384 -0.06851384
      regC_09    -0.06307790 -0.06307790 -0.06307790 -0.06307790 -0.06307790
      reg_no_C   -0.06723714 -0.06723714 -0.06723714 -0.06723714 -0.06723714
      regB_08     0.27160541  0.27160541  0.15829485  0.15829485  0.15829485
      reg_no_A    0.15829946  0.15829946  0.15829946  0.15829946  0.15829946
      regB_04    -0.06476611 -0.06476611 -0.06476611 -0.06476611 -0.06476611
      regC_06    -0.06695355 -0.06695355 -0.06695355 -0.06695355 -0.06695355
      regB_09    -0.06567703 -0.06567703 -0.06567703 -0.06567703 -0.06567703
      reg_no_AB  -0.06772276 -0.06772276 -0.06772276 -0.06772276 -0.06772276
      regC_04    -0.06778509 -0.06778509 -0.06778509 -0.06778509 -0.06778509
      regC_01    -0.06784948 -0.06784948 -0.06784948 -0.06784948 -0.06784948
      regC       -0.06755627 -0.06755627 -0.06755627 -0.06755627 -0.06755627
      regB_05    -0.06614767 -0.06614767 -0.06614767 -0.06614767 -0.06614767
      regB_02    -0.06429201 -0.06429201 -0.06429201 -0.06429201 -0.06429201
      regB_01    -0.06657653 -0.06657653 -0.06657653 -0.06657653 -0.06657653
      regB       -0.06480504 -0.06480504 -0.06480504 -0.06480504 -0.06480504
      regC_02     0.04790636  0.04790636  0.04790636  0.04790636  0.04790636
      regB_03     0.05186392  0.05186392  0.05186392  0.05186392  0.05186392
      regC_07     0.04918237  0.04918237  0.04918237  0.04918237  0.04918237
      reg_no_B    0.16530405  0.16530405  0.16530405  0.16530405  0.16530405
      regB_07    -0.06851326 -0.06851326 -0.06851326 -0.06851326 -0.06851326
      regB_06     0.04947548  0.04947548  0.04947548  0.04947548  0.04947548
      regC_08    -0.06684287 -0.06684287 -0.06684287 -0.06684287 -0.06684287
      regA_04     3.64263468  3.06342739  2.71590301  2.25253717  1.44164696
      regA_05     3.38368904  3.03843813  2.46301996  1.88760178  1.19709997
      regAB       3.22254818  2.87057510  2.40127766  2.04930458  1.58000715
      regA_06     2.78702840  2.55858345  2.10169355  1.75902612  1.18791375
      regAB_02    2.64083526  2.40560297  2.05275454  1.81752226  1.34705768
      regA_07     2.23482518  1.89001570  1.54520622  1.31533323  0.97052375
      regAB_04    2.08155598  1.96242613  1.48590670  1.24764699  0.89025742
                         150         160         170         180         190
      regA_01     1.87244355  1.64443046  1.41641736  1.07439771  0.39035842
      regA        2.13865186  1.90666879  1.67468573  1.21071960  0.39877888
      regA_02     1.53981906  1.42525771  1.19613502  1.08157367  0.27964425
      regA_03     1.43489293  1.31947362  1.31947362  0.97321567  0.39611909
      regD_04     0.61304177  0.84022048  1.18098856  1.52175663  1.97611406
      regD_06     0.49431600  0.60671163  0.94389854  1.16868980  1.28108544
      regD_02     0.95514177  0.95514177  1.52280002  1.74986332  2.20398992
      regD        1.28830992  1.51456737  2.19333972  2.64585462  3.21149825
      regA_09     0.28657908  0.28657908  0.40393332  0.40393332  0.28657908
      regAB_08    0.16475853  0.16475853  0.16475853  0.04930056  0.04930056
      regA_08     0.28140312  0.28140312  0.16715094  0.05289876  0.05289876
      regAB_06    0.28204347  0.16611932  0.16611932  0.16611932  0.05019516
      regD_08     0.27399274  0.27399274  0.50127829  0.61492107  0.84220663
      reg_no_ABC -0.06376465 -0.06376465 -0.06376465 -0.06376465 -0.06376465
      regC_03    -0.06760341 -0.06760341 -0.06760341 -0.06760341 -0.06760341
      regC_05    -0.06851384 -0.06851384 -0.06851384 -0.06851384 -0.06851384
      regC_09    -0.06307790 -0.06307790 -0.06307790 -0.06307790 -0.06307790
      reg_no_C   -0.06723714 -0.06723714 -0.06723714 -0.06723714 -0.06723714
      regB_08     0.15829485  0.15829485  0.15829485  0.15829485  0.15829485
      reg_no_A    0.15829946  0.15829946  0.15829946  0.15829946  0.15829946
      regB_04    -0.06476611 -0.06476611 -0.06476611 -0.06476611 -0.06476611
      regC_06    -0.06695355 -0.06695355 -0.06695355 -0.06695355 -0.06695355
      regB_09    -0.06567703 -0.06567703 -0.06567703 -0.06567703 -0.06567703
      reg_no_AB  -0.06772276 -0.06772276 -0.06772276 -0.06772276 -0.06772276
      regC_04    -0.06778509 -0.06778509 -0.06778509 -0.06778509 -0.06778509
      regC_01    -0.06784948 -0.06784948 -0.06784948 -0.06784948 -0.06784948
      regC       -0.06755627 -0.06755627 -0.06755627 -0.06755627 -0.06755627
      regB_05    -0.06614767 -0.06614767 -0.06614767 -0.06614767 -0.06614767
      regB_02    -0.06429201 -0.06429201 -0.06429201 -0.06429201 -0.06429201
      regB_01    -0.06657653 -0.06657653 -0.06657653 -0.06657653 -0.06657653
      regB       -0.06480504 -0.06480504 -0.06480504 -0.06480504 -0.06480504
      regC_02     0.04790636  0.04790636  0.04790636  0.04790636  0.04790636
      regB_03     0.05186392  0.05186392  0.05186392  0.05186392  0.05186392
      regC_07     0.04918237  0.04918237  0.04918237  0.04918237  0.04918237
      reg_no_B    0.04872856  0.04872856  0.04872856  0.04872856 -0.06784694
      regB_07    -0.06851326 -0.06851326 -0.06851326 -0.06851326 -0.06851326
      regB_06     0.04947548  0.04947548  0.04947548  0.04947548  0.04947548
      regC_08    -0.06684287 -0.06684287 -0.06684287 -0.06684287 -0.06684287
      regA_04     0.86243966  0.74659820  0.74659820  0.51491529  0.05154945
      regA_05     0.85184907  0.73676543  0.73676543  0.62168180  0.27643089
      regAB       1.22803407  0.99338535  0.99338535  0.64141227  0.05479048
      regA_06     0.95946880  0.84524632  0.73102384  0.38835642 -0.06853349
      regAB_02    0.99420926  0.87659311  0.87659311  0.64136083  0.05328011
      regA_07     0.85558726  0.74065077  0.62571427  0.28090479  0.05103180
      regAB_04    0.65199771  0.41373799  0.41373799  0.29460814 -0.06278143
                         200         210         220         230         240
      regA_01     0.27635187  0.27635187  0.16234533  0.04833878 -0.06566777
      regA        0.28278735  0.28278735  0.16679582  0.05080429 -0.06518724
      regA_02     0.16508290  0.16508290  0.05052155  0.05052155  0.05052155
      regA_03     0.28069978  0.28069978  0.16528046  0.04986114 -0.06555817
      regD_04     1.97611406  2.08970342  2.31688214  2.65765021  2.77123957
      regD_06     1.39348107  1.50587671  1.61827234  1.73066798  1.84306361
      regD_02     2.31752157  2.77164817  3.11224312  3.45283806  3.56636971
      regD        3.43775570  3.89027060  4.22965677  4.68217167  4.90842912
      regA_09     0.16922483  0.16922483  0.05187058  0.05187058  0.05187058
      regAB_08    0.04930056  0.04930056  0.04930056  0.04930056  0.04930056
      regA_08     0.05289876  0.05289876  0.05289876  0.05289876  0.05289876
      regAB_06   -0.06572900 -0.06572900 -0.06572900 -0.06572900 -0.06572900
      regD_08     0.84220663  1.06949218  1.18313496  1.18313496  1.18313496
      reg_no_ABC -0.06376465 -0.06376465 -0.06376465 -0.06376465 -0.06376465
      regC_03    -0.06760341 -0.06760341 -0.06760341  0.04795798  0.04795798
      regC_05    -0.06851384 -0.06851384  0.05002221  0.05002221  0.05002221
      regC_09    -0.06307790 -0.06307790 -0.06307790 -0.06307790 -0.06307790
      reg_no_C   -0.06723714 -0.06723714 -0.06723714 -0.06723714 -0.06723714
      regB_08     0.15829485  0.15829485  0.15829485  0.15829485  0.15829485
      reg_no_A    0.15829946  0.15829946  0.04571094  0.04571094 -0.06687758
      regB_04    -0.06476611 -0.06476611 -0.06476611 -0.06476611 -0.06476611
      regC_06    -0.06695355 -0.06695355 -0.06695355 -0.06695355 -0.06695355
      regB_09    -0.06567703 -0.06567703 -0.06567703 -0.06567703 -0.06567703
      reg_no_AB  -0.06772276 -0.06772276 -0.06772276 -0.06772276 -0.06772276
      regC_04    -0.06778509 -0.06778509 -0.06778509 -0.06778509 -0.06778509
      regC_01    -0.06784948 -0.06784948 -0.06784948 -0.06784948 -0.06784948
      regC       -0.06755627 -0.06755627 -0.06755627 -0.06755627 -0.06755627
      regB_05    -0.06614767 -0.06614767 -0.06614767 -0.06614767 -0.06614767
      regB_02    -0.06429201 -0.06429201 -0.06429201 -0.06429201 -0.06429201
      regB_01    -0.06657653 -0.06657653 -0.06657653 -0.06657653 -0.06657653
      regB       -0.06480504 -0.06480504 -0.06480504 -0.06480504 -0.06480504
      regC_02     0.04790636  0.04790636  0.04790636  0.04790636  0.04790636
      regB_03     0.05186392  0.05186392  0.05186392  0.05186392  0.05186392
      regC_07     0.04918237  0.04918237  0.04918237  0.04918237  0.04918237
      reg_no_B   -0.06784694 -0.06784694 -0.06784694 -0.06784694 -0.06784694
      regB_07    -0.06851326 -0.06851326 -0.06851326 -0.06851326 -0.06851326
      regB_06     0.04947548 -0.06639216 -0.06639216 -0.06639216 -0.06639216
      regC_08    -0.06684287 -0.06684287 -0.06684287 -0.06684287 -0.06684287
      regA_04    -0.06429201 -0.06429201 -0.06429201 -0.06429201 -0.06429201
      regA_05     0.16134726  0.16134726  0.04626362  0.04626362 -0.06882001
      regAB      -0.06253388 -0.06253388 -0.06253388 -0.06253388 -0.06253388
      regA_06    -0.06853349 -0.06853349 -0.06853349 -0.06853349 -0.06853349
      regAB_02   -0.06433603 -0.06433603 -0.06433603 -0.06433603 -0.06433603
      regA_07    -0.06390469 -0.06390469 -0.06390469 -0.06390469 -0.06390469
      regAB_04   -0.06278143 -0.06278143 -0.06278143 -0.06278143 -0.06278143
                         250         260         270         280         290
      regA_01    -0.06566777 -0.06566777 -0.06566777 -0.06566777 -0.06566777
      regA       -0.06518724 -0.06518724 -0.06518724 -0.06518724 -0.06518724
      regA_02     0.05052155  0.05052155  0.05052155  0.05052155  0.05052155
      regA_03    -0.06555817 -0.06555817 -0.06555817 -0.06555817 -0.06555817
      regD_04     2.88482893  3.11200765  3.22559700  3.22559700  3.33918636
      regD_06     1.84306361  1.95545924  1.95545924  1.95545924  2.06785488
      regD_02     3.79343301  4.02049631  4.13402796  4.13402796  4.24755961
      regD        5.13468657  5.36094402  5.47407275  5.47407275  5.70033020
      regA_09     0.05187058  0.05187058  0.05187058  0.05187058  0.05187058
      regAB_08    0.04930056  0.04930056  0.04930056  0.04930056  0.04930056
      regA_08     0.05289876  0.05289876  0.05289876  0.05289876  0.05289876
      regAB_06   -0.06572900 -0.06572900 -0.06572900 -0.06572900 -0.06572900
      regD_08     1.06949218  1.18313496  1.18313496  1.18313496  1.18313496
      reg_no_ABC -0.06376465 -0.06376465 -0.06376465 -0.06376465 -0.06376465
      regC_03     0.04795798  0.04795798  0.04795798  0.04795798  0.04795798
      regC_05     0.05002221  0.05002221  0.05002221  0.05002221  0.05002221
      regC_09    -0.06307790 -0.06307790 -0.06307790 -0.06307790 -0.06307790
      reg_no_C   -0.06723714 -0.06723714 -0.06723714 -0.06723714 -0.06723714
      regB_08     0.15829485  0.15829485  0.15829485  0.15829485  0.04498429
      reg_no_A   -0.06687758 -0.06687758 -0.06687758 -0.06687758 -0.06687758
      regB_04    -0.06476611 -0.06476611 -0.06476611 -0.06476611 -0.06476611
      regC_06    -0.06695355 -0.06695355 -0.06695355 -0.06695355 -0.06695355
      regB_09    -0.06567703 -0.06567703 -0.06567703 -0.06567703 -0.06567703
      reg_no_AB  -0.06772276 -0.06772276 -0.06772276 -0.06772276 -0.06772276
      regC_04    -0.06778509 -0.06778509 -0.06778509 -0.06778509 -0.06778509
      regC_01    -0.06784948 -0.06784948 -0.06784948 -0.06784948 -0.06784948
      regC       -0.06755627 -0.06755627 -0.06755627 -0.06755627 -0.06755627
      regB_05    -0.06614767 -0.06614767 -0.06614767 -0.06614767 -0.06614767
      regB_02    -0.06429201 -0.06429201 -0.06429201 -0.06429201 -0.06429201
      regB_01    -0.06657653 -0.06657653 -0.06657653 -0.06657653 -0.06657653
      regB       -0.06480504 -0.06480504 -0.06480504 -0.06480504 -0.06480504
      regC_02     0.04790636  0.04790636  0.04790636  0.04790636  0.04790636
      regB_03     0.05186392  0.05186392  0.05186392  0.05186392  0.05186392
      regC_07     0.04918237  0.04918237  0.04918237  0.04918237  0.04918237
      reg_no_B   -0.06784694 -0.06784694 -0.06784694 -0.06784694 -0.06784694
      regB_07    -0.06851326 -0.06851326 -0.06851326 -0.06851326 -0.06851326
      regB_06    -0.06639216 -0.06639216 -0.06639216 -0.06639216 -0.06639216
      regC_08    -0.06684287 -0.06684287 -0.06684287 -0.06684287 -0.06684287
      regA_04    -0.06429201 -0.06429201 -0.06429201 -0.06429201 -0.06429201
      regA_05    -0.06882001 -0.06882001 -0.06882001 -0.06882001 -0.06882001
      regAB      -0.06253388 -0.06253388 -0.06253388 -0.06253388 -0.06253388
      regA_06    -0.06853349 -0.06853349 -0.06853349 -0.06853349 -0.06853349
      regAB_02   -0.06433603 -0.06433603 -0.06433603 -0.06433603 -0.06433603
      regA_07    -0.06390469 -0.06390469 -0.06390469 -0.06390469 -0.06390469
      regAB_04   -0.06278143 -0.06278143 -0.06278143 -0.06278143  0.05634842
                         300         310         320         330         340
      regA_01     0.04833878  0.04833878  0.04833878  0.04833878  0.04833878
      regA        0.05080429  0.05080429  0.05080429  0.05080429  0.05080429
      regA_02     0.16508290  0.16508290  0.16508290  0.16508290  0.16508290
      regA_03     0.04986114  0.04986114  0.04986114  0.04986114  0.04986114
      regD_04     3.90713315  3.33918636  3.22559700  3.22559700  3.11200765
      regD_06     2.18025051  2.06785488  1.95545924  1.95545924  1.95545924
      regD_02     4.81521786  4.24755961  4.13402796  4.13402796  4.02049631
      regD        6.26597382  5.70033020  5.47407275  5.47407275  5.36094402
      regA_09    -0.06548367 -0.06548367 -0.06548367 -0.06548367 -0.06548367
      regAB_08    0.04930056  0.04930056 -0.06615742 -0.06615742 -0.06615742
      regA_08     0.05289876  0.05289876  0.05289876  0.05289876  0.05289876
      regAB_06    0.05019516  0.05019516  0.05019516  0.05019516  0.05019516
      regD_08     1.41042052  1.18313496  1.18313496  1.18313496  1.18313496
      reg_no_ABC -0.06376465 -0.06376465 -0.06376465 -0.06376465 -0.06376465
      regC_03     0.04795798  0.16351936  0.16351936  0.16351936  0.16351936
      regC_05     0.05002221  0.16855826  0.16855826  0.16855826  0.16855826
      regC_09    -0.06307790 -0.06307790 -0.06307790 -0.06307790 -0.06307790
      reg_no_C   -0.06723714 -0.06723714 -0.06723714 -0.06723714 -0.06723714
      regB_08     0.04498429  0.04498429  0.04498429  0.04498429  0.04498429
      reg_no_A   -0.06687758 -0.06687758 -0.06687758  0.04571094  0.04571094
      regB_04    -0.06476611 -0.06476611 -0.06476611 -0.06476611 -0.06476611
      regC_06    -0.06695355 -0.06695355 -0.06695355 -0.06695355  0.04633503
      regB_09    -0.06567703 -0.06567703 -0.06567703 -0.06567703 -0.06567703
      reg_no_AB  -0.06772276 -0.06772276 -0.06772276 -0.06772276 -0.06772276
      regC_04    -0.06778509 -0.06778509 -0.06778509 -0.06778509 -0.06778509
      regC_01    -0.06784948  0.04734488  0.04734488  0.04734488  0.04734488
      regC       -0.06755627  0.04993289  0.04993289  0.04993289  0.04993289
      regB_05    -0.06614767 -0.06614767 -0.06614767 -0.06614767 -0.06614767
      regB_02    -0.06429201 -0.06429201 -0.06429201 -0.06429201 -0.06429201
      regB_01    -0.06657653 -0.06657653 -0.06657653 -0.06657653 -0.06657653
      regB       -0.06480504 -0.06480504 -0.06480504 -0.06480504 -0.06480504
      regC_02    -0.06642863  0.04790636  0.04790636  0.04790636  0.04790636
      regB_03     0.05186392  0.05186392  0.05186392  0.05186392  0.05186392
      regC_07     0.04918237  0.04918237  0.04918237 -0.06681379 -0.06681379
      reg_no_B   -0.06784694 -0.06784694 -0.06784694 -0.06784694 -0.06784694
      regB_07    -0.06851326 -0.06851326 -0.06851326 -0.06851326 -0.06851326
      regB_06    -0.06639216 -0.06639216 -0.06639216 -0.06639216 -0.06639216
      regC_08    -0.06684287 -0.06684287 -0.06684287 -0.06684287 -0.06684287
      regA_04     0.05154945  0.05154945  0.05154945  0.05154945  0.05154945
      regA_05     0.04626362  0.04626362  0.04626362  0.04626362  0.04626362
      regAB       0.05479048  0.05479048  0.05479048  0.05479048  0.05479048
      regA_06    -0.06853349 -0.06853349 -0.06853349 -0.06853349 -0.06853349
      regAB_02    0.05328011  0.05328011  0.05328011  0.05328011  0.05328011
      regA_07     0.05103180  0.05103180  0.05103180  0.05103180  0.05103180
      regAB_04    0.17547828  0.17547828  0.17547828  0.17547828  0.17547828
                         350         360         370         380         390
      regA_01     0.04833878  0.04833878  0.04833878  0.04833878  0.04833878
      regA        0.05080429  0.05080429  0.05080429  0.05080429  0.05080429
      regA_02     0.16508290  0.16508290  0.16508290  0.16508290  0.16508290
      regA_03     0.04986114  0.04986114  0.04986114  0.04986114  0.04986114
      regD_04     2.88482893  2.77123957  2.65765021  2.31688214  2.08970342
      regD_06     1.84306361  1.84306361  1.73066798  1.61827234  1.50587671
      regD_02     3.79343301  3.56636971  3.45283806  3.11224312  2.77164817
      regD        5.13468657  4.90842912  4.68217167  4.22965677  3.89027060
      regA_09    -0.06548367 -0.06548367 -0.06548367 -0.06548367 -0.06548367
      regAB_08   -0.06615742 -0.06615742 -0.06615742 -0.06615742  0.04930056
      regA_08     0.05289876  0.05289876  0.05289876  0.16715094  0.16715094
      regAB_06    0.05019516  0.05019516  0.05019516  0.05019516  0.05019516
      regD_08     1.06949218  1.06949218  1.06949218  1.06949218  0.95584941
      reg_no_ABC -0.06376465  0.16726670  0.16726670  0.16726670  0.16726670
      regC_03     0.16351936  0.16351936  0.16351936  0.16351936  0.16351936
      regC_05     0.16855826  0.16855826  0.16855826  0.16855826  0.16855826
      regC_09    -0.06307790 -0.06307790 -0.06307790 -0.06307790 -0.06307790
      reg_no_C   -0.06723714 -0.06723714 -0.06723714 -0.06723714 -0.06723714
      regB_08     0.04498429  0.04498429  0.04498429 -0.06832627 -0.06832627
      reg_no_A    0.04571094  0.04571094  0.04571094  0.04571094  0.04571094
      regB_04    -0.06476611  0.05130219  0.05130219  0.05130219  0.05130219
      regC_06     0.04633503  0.04633503  0.04633503  0.04633503  0.04633503
      regB_09    -0.06567703 -0.06567703 -0.06567703 -0.06567703  0.05244712
      reg_no_AB  -0.06772276 -0.06772276 -0.06772276 -0.06772276 -0.06772276
      regC_04    -0.06778509 -0.06778509 -0.06778509 -0.06778509 -0.06778509
      regC_01     0.04734488  0.04734488  0.04734488  0.04734488  0.04734488
      regC        0.04993289  0.04993289  0.04993289  0.04993289  0.04993289
      regB_05    -0.06614767 -0.06614767 -0.06614767 -0.06614767 -0.06614767
      regB_02    -0.06429201 -0.06429201 -0.06429201 -0.06429201 -0.06429201
      regB_01    -0.06657653 -0.06657653 -0.06657653 -0.06657653 -0.06657653
      regB       -0.06480504 -0.06480504 -0.06480504 -0.06480504 -0.06480504
      regC_02     0.04790636  0.04790636  0.04790636  0.04790636  0.04790636
      regB_03     0.05186392 -0.06364593 -0.06364593 -0.06364593 -0.06364593
      regC_07    -0.06681379 -0.06681379 -0.06681379 -0.06681379 -0.06681379
      reg_no_B   -0.06784694 -0.06784694 -0.06784694 -0.06784694 -0.06784694
      regB_07    -0.06851326 -0.06851326 -0.06851326 -0.06851326 -0.06851326
      regB_06    -0.06639216 -0.06639216 -0.06639216 -0.06639216 -0.06639216
      regC_08    -0.06684287 -0.06684287 -0.06684287 -0.06684287 -0.06684287
      regA_04     0.05154945  0.05154945  0.05154945  0.05154945  0.05154945
      regA_05     0.04626362  0.04626362  0.04626362  0.04626362  0.04626362
      regAB       0.05479048  0.05479048  0.05479048  0.05479048  0.05479048
      regA_06    -0.06853349 -0.06853349 -0.06853349 -0.06853349 -0.06853349
      regAB_02    0.05328011  0.05328011  0.05328011  0.17089626  0.17089626
      regA_07     0.05103180  0.05103180  0.05103180  0.05103180  0.05103180
      regAB_04    0.17547828  0.17547828  0.17547828  0.17547828  0.17547828
                         400         410         420         430         440
      regA_01     0.04833878  0.04833878  0.04833878  0.04833878  0.04833878
      regA        0.05080429  0.05080429  0.05080429  0.05080429  0.05080429
      regA_02     0.16508290  0.16508290  0.16508290  0.16508290  0.16508290
      regA_03     0.04986114  0.04986114  0.04986114  0.04986114  0.16528046
      regD_04     1.97611406  1.97611406  1.52175663  1.18098856  0.95380984
      regD_06     1.39348107  1.28108544  1.16868980  0.94389854  0.60671163
      regD_02     2.31752157  2.20398992  1.74986332  1.52280002  0.95514177
      regD        3.43775570  3.21149825  2.64585462  2.19333972  1.51456737
      regA_09    -0.06548367 -0.06548367 -0.06548367 -0.06548367 -0.06548367
      regAB_08    0.04930056  0.04930056  0.04930056  0.04930056  0.04930056
      regA_08     0.16715094  0.16715094  0.16715094  0.16715094  0.16715094
      regAB_06    0.05019516  0.05019516  0.05019516  0.05019516  0.05019516
      regD_08     0.84220663  0.84220663  0.61492107  0.50127829  0.27399274
      reg_no_ABC  0.16726670  0.16726670  0.16726670  0.16726670  0.28278237
      regC_03     0.27908075  0.27908075  0.27908075  0.16351936  0.16351936
      regC_05     0.16855826  0.16855826  0.16855826  0.16855826  0.16855826
      regC_09    -0.06307790 -0.06307790 -0.06307790 -0.06307790 -0.06307790
      reg_no_C   -0.06723714 -0.06723714 -0.06723714 -0.06723714 -0.06723714
      regB_08    -0.06832627 -0.06832627 -0.06832627 -0.06832627 -0.06832627
      reg_no_A    0.04571094  0.04571094  0.04571094  0.04571094  0.04571094
      regB_04     0.05130219  0.05130219  0.05130219  0.05130219  0.05130219
      regC_06     0.04633503  0.04633503  0.04633503  0.04633503  0.04633503
      regB_09     0.05244712  0.05244712  0.05244712  0.05244712  0.05244712
      reg_no_AB  -0.06772276 -0.06772276 -0.06772276 -0.06772276  0.04843978
      regC_04    -0.06778509 -0.06778509 -0.06778509 -0.06778509 -0.06778509
      regC_01     0.04734488  0.04734488  0.04734488  0.04734488  0.04734488
      regC        0.04993289  0.04993289  0.04993289  0.04993289  0.04993289
      regB_05    -0.06614767 -0.06614767 -0.06614767 -0.06614767  0.05010482
      regB_02    -0.06429201 -0.06429201 -0.06429201 -0.06429201 -0.06429201
      regB_01    -0.06657653 -0.06657653 -0.06657653 -0.06657653 -0.06657653
      regB       -0.06480504 -0.06480504 -0.06480504 -0.06480504 -0.06480504
      regC_02     0.04790636  0.04790636  0.04790636  0.04790636  0.04790636
      regB_03    -0.06364593 -0.06364593 -0.06364593 -0.06364593 -0.06364593
      regC_07    -0.06681379 -0.06681379 -0.06681379 -0.06681379 -0.06681379
      reg_no_B   -0.06784694 -0.06784694 -0.06784694 -0.06784694 -0.06784694
      regB_07    -0.06851326 -0.06851326 -0.06851326 -0.06851326 -0.06851326
      regB_06    -0.06639216 -0.06639216 -0.06639216 -0.06639216 -0.06639216
      regC_08    -0.06684287 -0.06684287 -0.06684287 -0.06684287 -0.06684287
      regA_04     0.05154945  0.05154945  0.05154945  0.05154945  0.05154945
      regA_05     0.04626362  0.04626362  0.04626362  0.04626362  0.04626362
      regAB       0.05479048  0.05479048  0.05479048  0.05479048  0.05479048
      regA_06    -0.06853349 -0.06853349 -0.06853349 -0.06853349 -0.06853349
      regAB_02    0.17089626  0.17089626  0.17089626  0.17089626  0.17089626
      regA_07     0.05103180  0.05103180  0.05103180  0.05103180  0.05103180
      regAB_04    0.17547828  0.17547828  0.17547828  0.17547828  0.17547828
                         450         460         470         480         490
      regA_01     0.04833878  0.04833878  0.04833878  0.04833878  0.04833878
      regA        0.05080429  0.05080429  0.05080429  0.05080429  0.05080429
      regA_02     0.16508290  0.16508290  0.16508290  0.16508290  0.16508290
      regA_03     0.16528046  0.16528046  0.16528046  0.16528046  0.16528046
      regD_04     0.72663112  0.61304177  0.61304177  0.49945241  0.27227369
      regD_06     0.49431600  0.49431600  0.38192037  0.26952473  0.04473346
      regD_02     0.95514177  0.84161012  0.61454682  0.38748352  0.04688857
      regD        1.28830992  1.17518120  0.94892375  0.60953757  0.15702267
      regA_09    -0.06548367 -0.06548367 -0.06548367 -0.06548367 -0.06548367
      regAB_08    0.04930056  0.04930056  0.04930056  0.04930056  0.04930056
      regA_08     0.16715094  0.05289876  0.05289876  0.05289876  0.05289876
      regAB_06    0.05019516  0.05019516  0.05019516  0.05019516  0.05019516
      regD_08     0.27399274  0.16034996  0.16034996  0.16034996  0.04670718
      reg_no_ABC  0.28278237  0.28278237  0.28278237  0.28278237  0.28278237
      regC_03     0.16351936  0.16351936  0.16351936  0.27908075  0.27908075
      regC_05     0.16855826  0.16855826  0.16855826  0.16855826  0.16855826
      regC_09    -0.06307790 -0.06307790 -0.06307790 -0.06307790 -0.06307790
      reg_no_C   -0.06723714 -0.06723714 -0.06723714 -0.06723714 -0.06723714
      regB_08    -0.06832627 -0.06832627 -0.06832627 -0.06832627 -0.06832627
      reg_no_A    0.04571094  0.04571094  0.04571094  0.04571094  0.04571094
      regB_04     0.05130219  0.05130219  0.05130219  0.05130219  0.05130219
      regC_06     0.04633503  0.04633503  0.04633503  0.04633503  0.04633503
      regB_09     0.05244712  0.05244712  0.05244712  0.05244712  0.05244712
      reg_no_AB   0.04843978  0.04843978  0.04843978  0.04843978  0.04843978
      regC_04    -0.06778509 -0.06778509 -0.06778509 -0.06778509  0.04868414
      regC_01     0.04734488  0.04734488  0.04734488  0.04734488  0.04734488
      regC        0.04993289  0.04993289  0.04993289  0.04993289  0.04993289
      regB_05     0.05010482  0.05010482  0.05010482  0.05010482  0.05010482
      regB_02    -0.06429201 -0.06429201 -0.06429201 -0.06429201 -0.06429201
      regB_01    -0.06657653 -0.06657653 -0.06657653 -0.06657653 -0.06657653
      regB       -0.06480504 -0.06480504 -0.06480504 -0.06480504 -0.06480504
      regC_02     0.04790636  0.04790636  0.04790636  0.04790636  0.04790636
      regB_03    -0.06364593 -0.06364593 -0.06364593 -0.06364593 -0.06364593
      regC_07    -0.06681379 -0.06681379 -0.06681379 -0.06681379 -0.06681379
      reg_no_B   -0.06784694 -0.06784694 -0.06784694 -0.06784694 -0.06784694
      regB_07    -0.06851326 -0.06851326 -0.06851326 -0.06851326 -0.06851326
      regB_06    -0.06639216 -0.06639216 -0.06639216 -0.06639216 -0.06639216
      regC_08    -0.06684287 -0.06684287 -0.06684287 -0.06684287 -0.06684287
      regA_04     0.05154945  0.05154945  0.05154945  0.05154945  0.05154945
      regA_05     0.04626362  0.04626362  0.04626362  0.04626362  0.04626362
      regAB       0.05479048  0.05479048  0.05479048  0.05479048  0.05479048
      regA_06    -0.06853349 -0.06853349 -0.06853349 -0.06853349 -0.06853349
      regAB_02    0.17089626  0.17089626  0.17089626  0.17089626  0.17089626
      regA_07     0.05103180  0.05103180  0.05103180  0.05103180  0.05103180
      regAB_04    0.17547828  0.17547828  0.17547828  0.17547828  0.17547828
                         500         510         520         530         540
      regA_01     0.04833878  0.04833878  0.04833878  0.04833878  0.04833878
      regA        0.05080429  0.05080429  0.05080429  0.05080429  0.05080429
      regA_02     0.16508290  0.05052155  0.05052155  0.05052155  0.05052155
      regA_03     0.16528046  0.16528046  0.16528046  0.16528046  0.16528046
      regD_04     0.15868433  0.15868433  0.15868433  0.04509498  0.04509498
      regD_06     0.04473346  0.04473346  0.04473346 -0.06766217 -0.06766217
      regD_02     0.04688857  0.04688857  0.04688857 -0.06664308 -0.06664308
      regD        0.04389395  0.04389395  0.04389395 -0.06923478 -0.06923478
      regA_09    -0.06548367 -0.06548367 -0.06548367 -0.06548367 -0.06548367
      regAB_08    0.04930056  0.04930056  0.04930056  0.04930056  0.04930056
      regA_08     0.05289876  0.05289876  0.05289876  0.05289876  0.05289876
      regAB_06    0.05019516  0.05019516  0.05019516  0.05019516  0.05019516
      regD_08     0.04670718  0.04670718  0.04670718  0.04670718  0.04670718
      reg_no_ABC  0.28278237  0.28278237  0.28278237  0.28278237  0.28278237
      regC_03     0.27908075  0.27908075  0.27908075  0.27908075  0.27908075
      regC_05     0.05002221  0.05002221  0.05002221  0.05002221  0.05002221
      regC_09    -0.06307790 -0.06307790 -0.06307790 -0.06307790 -0.06307790
      reg_no_C   -0.06723714 -0.06723714 -0.06723714 -0.06723714 -0.06723714
      regB_08    -0.06832627 -0.06832627 -0.06832627 -0.06832627 -0.06832627
      reg_no_A    0.04571094  0.04571094  0.04571094  0.04571094  0.04571094
      regB_04    -0.06476611 -0.06476611 -0.06476611 -0.06476611 -0.06476611
      regC_06     0.04633503 -0.06695355 -0.06695355 -0.06695355 -0.06695355
      regB_09     0.05244712  0.05244712  0.05244712  0.05244712  0.05244712
      reg_no_AB   0.04843978  0.04843978  0.04843978  0.04843978  0.04843978
      regC_04     0.04868414  0.04868414  0.04868414  0.04868414  0.04868414
      regC_01     0.04734488  0.04734488  0.04734488  0.04734488  0.04734488
      regC        0.04993289  0.04993289  0.04993289  0.04993289  0.04993289
      regB_05     0.05010482  0.05010482  0.05010482  0.05010482  0.05010482
      regB_02    -0.06429201 -0.06429201 -0.06429201 -0.06429201 -0.06429201
      regB_01    -0.06657653 -0.06657653 -0.06657653 -0.06657653 -0.06657653
      regB       -0.06480504 -0.06480504 -0.06480504 -0.06480504 -0.06480504
      regC_02     0.04790636  0.04790636  0.04790636  0.04790636  0.04790636
      regB_03    -0.06364593 -0.06364593 -0.06364593 -0.06364593 -0.06364593
      regC_07    -0.06681379 -0.06681379 -0.06681379 -0.06681379 -0.06681379
      reg_no_B   -0.06784694 -0.06784694 -0.06784694 -0.06784694 -0.06784694
      regB_07    -0.06851326 -0.06851326 -0.06851326 -0.06851326 -0.06851326
      regB_06    -0.06639216 -0.06639216 -0.06639216 -0.06639216 -0.06639216
      regC_08    -0.06684287 -0.06684287 -0.06684287 -0.06684287 -0.06684287
      regA_04     0.05154945  0.05154945  0.05154945  0.05154945  0.05154945
      regA_05     0.04626362  0.04626362  0.04626362  0.04626362  0.04626362
      regAB       0.05479048  0.05479048  0.05479048  0.05479048  0.05479048
      regA_06    -0.06853349 -0.06853349 -0.06853349 -0.06853349 -0.06853349
      regAB_02    0.17089626  0.17089626  0.05328011  0.05328011  0.05328011
      regA_07     0.05103180  0.05103180  0.05103180  0.05103180  0.05103180
      regAB_04    0.17547828  0.05634842  0.05634842  0.05634842  0.05634842
                         550         560         570         580         590
      regA_01    -0.06566777 -0.06566777 -0.06566777 -0.06566777 -0.06566777
      regA       -0.06518724 -0.06518724 -0.06518724 -0.06518724 -0.06518724
      regA_02    -0.06403979 -0.06403979 -0.06403979 -0.06403979 -0.06403979
      regA_03     0.04986114  0.04986114  0.04986114  0.04986114  0.04986114
      regD_04     0.04509498  0.04509498  0.04509498  0.04509498  0.15868433
      regD_06    -0.06766217 -0.06766217 -0.06766217 -0.06766217 -0.06766217
      regD_02    -0.06664308 -0.06664308 -0.06664308 -0.06664308 -0.06664308
      regD       -0.06923478 -0.06923478 -0.06923478 -0.06923478 -0.06923478
      regA_09    -0.06548367 -0.06548367 -0.06548367 -0.06548367 -0.06548367
      regAB_08    0.04930056  0.04930056  0.04930056  0.04930056 -0.06615742
      regA_08     0.05289876  0.05289876 -0.06135342 -0.06135342 -0.06135342
      regAB_06    0.05019516  0.05019516  0.05019516  0.05019516  0.05019516
      regD_08     0.04670718  0.04670718 -0.06693560 -0.06693560 -0.06693560
      reg_no_ABC  0.28278237  0.28278237  0.28278237  0.28278237  0.28278237
      regC_03     0.27908075  0.27908075  0.27908075  0.27908075  0.27908075
      regC_05     0.05002221  0.05002221  0.05002221  0.05002221  0.05002221
      regC_09    -0.06307790 -0.06307790 -0.06307790 -0.06307790 -0.06307790
      reg_no_C   -0.06723714 -0.06723714 -0.06723714 -0.06723714 -0.06723714
      regB_08    -0.06832627 -0.06832627 -0.06832627 -0.06832627 -0.06832627
      reg_no_A    0.04571094  0.04571094  0.04571094  0.04571094  0.04571094
      regB_04    -0.06476611 -0.06476611 -0.06476611  0.05130219  0.05130219
      regC_06    -0.06695355 -0.06695355 -0.06695355  0.04633503  0.04633503
      regB_09     0.05244712  0.05244712  0.05244712  0.05244712  0.05244712
      reg_no_AB   0.04843978  0.04843978  0.04843978  0.04843978  0.04843978
      regC_04     0.04868414  0.04868414  0.04868414  0.16515337  0.16515337
      regC_01     0.04734488  0.04734488  0.04734488  0.04734488  0.04734488
      regC        0.04993289  0.04993289  0.04993289  0.16742206  0.16742206
      regB_05     0.05010482  0.05010482  0.05010482  0.05010482  0.16635732
      regB_02    -0.06429201 -0.06429201 -0.06429201  0.05154945  0.05154945
      regB_01    -0.06657653 -0.06657653 -0.06657653  0.04900773  0.04900773
      regB       -0.06480504 -0.06480504 -0.06480504  0.04989415  0.04989415
      regC_02     0.04790636  0.04790636  0.04790636  0.16224136  0.16224136
      regB_03    -0.06364593 -0.06364593 -0.06364593  0.05186392  0.05186392
      regC_07    -0.06681379  0.04918237  0.04918237  0.04918237  0.04918237
      reg_no_B   -0.06784694 -0.06784694 -0.06784694 -0.06784694 -0.06784694
      regB_07    -0.06851326 -0.06851326 -0.06851326 -0.06851326 -0.06851326
      regB_06    -0.06639216 -0.06639216 -0.06639216 -0.06639216 -0.06639216
      regC_08    -0.06684287 -0.06684287 -0.06684287 -0.06684287 -0.06684287
      regA_04    -0.06429201 -0.06429201 -0.06429201 -0.06429201 -0.06429201
      regA_05    -0.06882001 -0.06882001 -0.06882001 -0.06882001  0.04626362
      regAB      -0.06253388 -0.06253388 -0.06253388 -0.06253388 -0.06253388
      regA_06    -0.06853349 -0.06853349 -0.06853349 -0.06853349 -0.06853349
      regAB_02   -0.06433603 -0.06433603 -0.06433603 -0.06433603 -0.06433603
      regA_07    -0.06390469 -0.06390469 -0.06390469 -0.06390469 -0.06390469
      regAB_04   -0.06278143 -0.06278143 -0.06278143 -0.06278143 -0.06278143
                         600
      regA_01    -0.06566777
      regA       -0.06518724
      regA_02    -0.06403979
      regA_03     0.04986114
      regD_04     0.15868433
      regD_06    -0.06766217
      regD_02    -0.06664308
      regD       -0.06923478
      regA_09    -0.06548367
      regAB_08   -0.06615742
      regA_08    -0.06135342
      regAB_06   -0.06572900
      regD_08    -0.06693560
      reg_no_ABC  0.16726670
      regC_03     0.27908075
      regC_05     0.05002221
      regC_09    -0.06307790
      reg_no_C   -0.06723714
      regB_08    -0.06832627
      reg_no_A    0.04571094
      regB_04     0.05130219
      regC_06     0.04633503
      regB_09     0.05244712
      reg_no_AB  -0.06772276
      regC_04     0.16515337
      regC_01     0.04734488
      regC        0.16742206
      regB_05     0.16635732
      regB_02     0.05154945
      regB_01     0.04900773
      regB        0.04989415
      regC_02     0.16224136
      regB_03     0.05186392
      regC_07     0.16517854
      reg_no_B   -0.06784694
      regB_07    -0.06851326
      regB_06    -0.06639216
      regC_08    -0.06684287
      regA_04    -0.06429201
      regA_05     0.04626362
      regAB      -0.06253388
      regA_06    -0.06853349
      regAB_02   -0.06433603
      regA_07    -0.06390469
      regAB_04   -0.06278143

