% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_AllClasses.R, R/02_plot.R,
%   R/ExWAS-extract.R, R/ExWAS-get_robust_sd.R, R/ExWAS-names.R,
%   R/ExWAS-plotEffect.R, R/ExWAS-plotExwas.R, R/ExWAS-plotVolcano.R,
%   R/ExWAS-tef.R
\docType{class}
\name{ExWAS}
\alias{ExWAS}
\alias{ExWAS-class}
\alias{plot,ExWAS,ANY-method}
\alias{extract,ExWAS-method}
\alias{get_robust_sd,ExWAS-method}
\alias{names,ExWAS-method}
\alias{plotEffect,ExWAS-method}
\alias{plotExwas,ExWAS-method}
\alias{plotVolcano,ExWAS-method}
\alias{tef,ExWAS-method}
\title{Class ExWAS}
\usage{
\S4method{plot}{ExWAS,ANY}(x, y, ...)

\S4method{extract}{ExWAS}(object, sort = TRUE, ...)

\S4method{get_robust_sd}{ExWAS}(object, sort = TRUE, ...)

\S4method{names}{ExWAS}(x)

\S4method{plotEffect}{ExWAS}(x, y, select, labels, xlab, ylab)

\S4method{plotExwas}{ExWAS}(
  object,
  ...,
  subtitles,
  color,
  exp.order,
  labels,
  show.effective = TRUE
)

\S4method{plotVolcano}{ExWAS}(x, p.value = -log10(0.001), labels, show.effect = FALSE)

\S4method{tef}{ExWAS}(object)
}
\arguments{
\item{x}{An \code{\link{ExWAS}} object}

\item{y}{An \code{\link{ExWAS}} object}

\item{...}{NOT USED}

\item{object}{An object of class \code{ExWAS}, \code{mExWAS} or \code{nlExWAS}.}

\item{sort}{If \code{TRUE}, the results are ordered by pvalue.}

\item{select}{(optional) Vector with the selected exposures}

\item{labels}{(optional) Character vector with the labels for each exposure.
It must be labeled vector.}

\item{xlab}{(optional) Label for x-axis}

\item{ylab}{(optional) Label for y-axis}

\item{subtitles}{Character vector with the "subtitle" for each plot when
given more than one \code{ExWAS}.}

\item{color}{(optional) A vector of colors. The vector must have length
equal to the number of families. The vector must be names with the
name of the families.}

\item{exp.order}{(optional) Order of the exposures.}

\item{show.effective}{(default TRUE) draws a brown line on the
threshold given by the effective number of tests.}

\item{p.value}{(default \code{-log10(0.001)}) Is the threshold from where
the exposures can be taken as significants.}

\item{show.effect}{(default \code{false}) Apply \code{exp} to obtained
beta.}
}
\value{
An object of class \code{ExWAS}
}
\description{
Class \code{ExWAS} obtained from \link{exwas} method of an
\link{ExposomeSet} object, contains the result of testing the association
of exposures of an \code{ExposomeSet} to its phenotypes. "ExWAS" is the
acronym of "Exposome-Wide Association  Study". The function can be applied
to one of to many phenotypes in the \code{ExposomeSet} object.
}
\section{Methods (by generic)}{
\itemize{
\item \code{plot(x = ExWAS, y = ANY)}: Wrapper for \code{plotExwas} method.

\item \code{extract(ExWAS)}: Method to obtain the matrix of association scores

\item \code{get_robust_sd(ExWAS)}: Method to obtain the matrix of association scores

\item \code{names(ExWAS)}: Method to obtain the Threshold for effective tests (TEF)

\item \code{plotEffect(ExWAS)}: Draws a plot with the confidence interval of each
exposure. Alows to compare two ExWAS instances.

\item \code{plotExwas(ExWAS)}: Method to plot a manhatan plot for association between
exposures and phenitypes

\item \code{plotVolcano(ExWAS)}: Method to plot a volcano plot for association between
exposures and phenotypes

\item \code{tef(ExWAS)}: Method to obtain the Threshold for effective tests (TEF)

}}
\section{Slots}{

\describe{
\item{\code{effective}}{Number containing the effective number of tests.}

\item{\code{formula}}{Tested formula.}

\item{\code{comparison}}{Result of performing the test to find association between
levels of exposures and phenotype.}

\item{\code{description}}{Description of the exposures used in the ExWAS.
(in description file).}
}}

\seealso{
\code{\link{exwas}} to perform an Exposome-Wide  Association Study
and to create an \code{\link{ExWAS}}, \code{\link{mexwas}} to perform a
Multivariate Exposome-Wide Association Study and to create a
\code{\link{mExWAS}}
}
