% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_AllClasses.R, R/02_plot.R,
%   R/ExposomeSet-clustering.R, R/ExposomeSet-correlation.R,
%   R/ExposomeSet-dim.R, R/ExposomeSet-expos.R, R/ExposomeSet-exposureNames.R,
%   R/ExposomeSet-exwas.R, R/ExposomeSet-familyNames.R,
%   R/ExposomeSet-highAndLow.R, R/ExposomeSet-ilod.R,
%   R/ExposomeSet-imputation.R, R/ExposomeSet-invExWAS.R,
%   R/ExposomeSet-mexwas.R, R/ExposomeSet-normalityTest.R, R/ExposomeSet-pca.R,
%   R/ExposomeSet-phenotypeNames.R, R/ExposomeSet-plotFamily.R,
%   R/ExposomeSet-plotHistogram.R, R/ExposomeSet-plotLOD.R,
%   R/ExposomeSet-plotMissings.R, R/ExposomeSet-standardize.R,
%   R/ExposomeSet-summary.R, R/ExposomeSet-tableLOD.R,
%   R/ExposomeSet-tableMissings.R, R/ExposomeSet-trans.R
\docType{class}
\name{ExposomeSet}
\alias{ExposomeSet}
\alias{ExposomeSet-class}
\alias{plot,ExposomeSet,ANY-method}
\alias{clustering,ExposomeSet-method}
\alias{correlation,ExposomeSet-method}
\alias{dim,ExposomeSet-method}
\alias{expos,ExposomeSet-method}
\alias{exposureNames,ExposomeSet-method}
\alias{exwas,ExposomeSet-method}
\alias{familyNames,ExposomeSet-method}
\alias{highAndLow,ExposomeSet-method}
\alias{ilod,ExposomeSet-method}
\alias{imputation,ExposomeSet-method}
\alias{invExWAS,ExposomeSet-method}
\alias{mexwas,ExposomeSet-method}
\alias{normalityTest,ExposomeSet-method}
\alias{pca,ExposomeSet-method}
\alias{phenotypeNames,ExposomeSet-method}
\alias{plotFamily,ExposomeSet-method}
\alias{plotHistogram,ExposomeSet-method}
\alias{plotLOD,ExposomeSet-method}
\alias{plotMissings,ExposomeSet-method}
\alias{standardize,ExposomeSet-method}
\alias{Summary,ExposomeSet-method}
\alias{tableLOD,ExposomeSet-method}
\alias{tableMissings,ExposomeSet-method}
\alias{trans,ExposomeSet-method}
\title{Class ExposomeSet}
\usage{
\S4method{plot}{ExposomeSet,ANY}(x, y, ...)

\S4method{clustering}{ExposomeSet}(object, method, cmethod, ..., warnings = TRUE)

\S4method{correlation}{ExposomeSet}(object, ..., warnings = TRUE)

\S4method{dim}{ExposomeSet}(x)

\S4method{expos}{ExposomeSet}(object)

\S4method{exposureNames}{ExposomeSet}(object)

\S4method{exwas}{ExposomeSet}(
  object,
  formula,
  filter,
  family,
  ...,
  baselevels,
  tef = TRUE,
  verbose = FALSE,
  warnings = TRUE,
  robust = FALSE
)

\S4method{familyNames}{ExposomeSet}(object, by.exposure = FALSE)

\S4method{highAndLow}{ExposomeSet}(
  object,
  ngroups = 3,
  intervals = c("standard", "extreme"),
  select,
  drop = FALSE,
  warnings = TRUE
)

\S4method{ilod}{ExposomeSet}(
  object,
  seed = 1234,
  lod.col = "LOD",
  pNA = 0.2,
  tLog = FALSE,
  method = "QRILC",
  warnings = TRUE,
  ...
)

\S4method{imputation}{ExposomeSet}(object, select, ..., messages = FALSE)

\S4method{invExWAS}{ExposomeSet}(object, formula, filter, tef = TRUE, verbose = FALSE, warnings = TRUE)

\S4method{mexwas}{ExposomeSet}(object, phenotype, family, warnings = TRUE)

\S4method{normalityTest}{ExposomeSet}(
  object,
  exposure,
  th = 0.05,
  min.val = 5,
  na.rm = TRUE,
  warnings = TRUE
)

\S4method{pca}{ExposomeSet}(object, npc = 10, pca = FALSE, ...)

\S4method{phenotypeNames}{ExposomeSet}(object)

\S4method{plotFamily}{ExposomeSet}(x, family, group, group2, scatter = TRUE, na.omit = TRUE)

\S4method{plotHistogram}{ExposomeSet}(x, select, density = TRUE, show.trans = FALSE)

\S4method{plotLOD}{ExposomeSet}(object, lod.col = "LOD", x.max = 100, sort = TRUE)

\S4method{plotMissings}{ExposomeSet}(
  object,
  set = c("exposures", "phenotypes"),
  x.max = 100,
  sort = TRUE
)

\S4method{standardize}{ExposomeSet}(object, select, method = "normal", na.rm = TRUE, warnings = TRUE)

\S4method{Summary}{ExposomeSet}(x, set = c("exposures", "phenotypes"), select, ..., na.rm = FALSE)

\S4method{tableLOD}{ExposomeSet}(object, output = "n", lod.col = "LOD", sort = TRUE)

\S4method{tableMissings}{ExposomeSet}(
  object,
  set = c("exposures", "phenotypes"),
  output = "n",
  sort = TRUE
)

\S4method{trans}{ExposomeSet}(object, fun, select, by.exposure = FALSE, ...)
}
\arguments{
\item{x}{An \code{\link{ExposomeSet}} object.}

\item{y}{NOT USED}

\item{...}{Arguments to be passed to imputeFAMD}

\item{object}{An \code{\link{ExposomeSet}} object.}

\item{method}{Method to be used.}

\item{cmethod}{Function implementing a systsme to retrieve classification
from clustering output}

\item{warnings}{If set to \code{TRUE} it prints the warning messsages.}

\item{formula}{Formula, not including exposures, to be tested. No need to provide response (left term)}

\item{filter}{Expression to be used to filter \code{\link{ExposomeSet}}}

\item{family}{Family descriving the nature of the health outcome}

\item{baselevels}{Labeled vector with the default base level for categorical exposures.}

\item{tef}{If \code{TRUE} it computed the threshold for effective tests.}

\item{verbose}{If set to \code{TRUE} is shows messages on progression.}

\item{by.exposure}{If set to \code{TRUE} ir returns the family which
each exposure belongs}

\item{ngroups}{Number of intervals to be used}

\item{intervals}{If \code{"standard"} all levels are kept, if
\code{"extreme"} intermetiate levels are set to \code{NA}.}

\item{select}{Vector selecting thee xposures to be used.}

\item{drop}{If set to \code{TRUE} exposures are replaced}

\item{seed}{Numeric seed}

\item{lod.col}{Indicator of the column where the LOD is located}

\item{pNA}{Maximum percentage allowed of values under LOD}

\item{tLog}{If set to \code{TRUE} it transforms all the exposures to lod
before the imputation.}

\item{messages}{If set to \code{TRUE} messages from  \code{mice}'s function
will be displayed.}

\item{phenotype}{Health outcome to be used as dependent variable.}

\item{exposure}{Vecror of exposures to be used.}

\item{th}{Threshold of P-Value used to considere normalit}

\item{min.val}{Minimum number of observations to perform test}

\item{na.rm}{If set to \code{TRUE} removes \code{NA} values}

\item{npc}{Number of PC to be kept}

\item{pca}{Perform PCA (only numerical variables) or FAMD (numerical and categorical)}

\item{group}{Phenotype to group exposures}

\item{group2}{Phenotype to group exposures}

\item{scatter}{If set to true it shows the samples value in the plot}

\item{na.omit}{If set to \code{TRUE}, \code{NA} values are discarded}

\item{density}{If set to \code{TRUE} a desntiry plot is draw on the
histogram}

\item{show.trans}{If set to \code{TRUE}, three extra plots are drawn
with usual transformations}

\item{x.max}{Threshold for x axis (in \%)}

\item{sort}{If set to \code{TRUE}, results are ordered}

\item{set}{Cantake values \code{"exposures"} or \code{"phentoypes"}.}

\item{output}{Can take values \code{"n"} (count) ot \code{"p"} (percentage)}

\item{fun}{Function to bt used in the transformation process}
}
\value{
An object of class \code{ExposomeSet}
}
\description{
Class \code{ExposomeSet} contains the exposure levels, the exposure's
description and the samples phenotype. It is the starting object for
\code{rexposome} package and extends \link{eSet}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{plot(x = ExposomeSet, y = ANY)}: Wrapper for \code{plotFamily} method.

\item \code{clustering(ExposomeSet)}: Performs clustering on samples based on exposure levels.

\item \code{correlation(ExposomeSet)}: Computes correlation on exposures.

\item \code{dim(ExposomeSet)}: Returns the number of exsures, samples and phenotypes.

\item \code{expos(ExposomeSet)}: Returns a \code{data.frame} with exposures.

\item \code{exposureNames(ExposomeSet)}: Getter to obtain the exposures's names.

\item \code{exwas(ExposomeSet)}: Performs an EXposome-Wide Association Study

\item \code{familyNames(ExposomeSet)}: Getter to obtain the families's names of the
family of each exposure.

\item \code{highAndLow(ExposomeSet)}: Performs a discretization of continuous exposures.

\item \code{ilod(ExposomeSet)}: Imputation of under-LOD values of exposures.

\item \code{imputation(ExposomeSet)}: Imputation of missing values of exposures.

\item \code{invExWAS(ExposomeSet)}: Performs an EXposome-Wide Association Study (modelling the exposures as response)

\item \code{mexwas(ExposomeSet)}: Performs a Multiple-EXposure-Wide Association Study.

\item \code{normalityTest(ExposomeSet)}: Test the normality of each exposure.

\item \code{pca(ExposomeSet)}: Performs a PCA

\item \code{phenotypeNames(ExposomeSet)}: Getter to obtain the phenotypes's names.

\item \code{plotFamily(ExposomeSet)}: Draws a boxplot or accumulated-bar plot for each
exposure in a given family.

\item \code{plotHistogram(ExposomeSet)}: Draws an histogram of a given continuous exposure
or a pie chart if a given categorycal exposure.

\item \code{plotLOD(ExposomeSet)}: Draws a barchart with the amount of under-LOD values.

\item \code{plotMissings(ExposomeSet)}: Draws a bar-plot with the amount of missing values.

\item \code{standardize(ExposomeSet)}: Standardization of exposures.

\item \code{Summary(ExposomeSet)}: Summary of both continuous and categorical exposures

\item \code{tableLOD(ExposomeSet)}: Returns a vector with the number of under-LOD values
per exposure.

\item \code{tableMissings(ExposomeSet)}: Returns a vector with the number of missing values
per exposure.

\item \code{trans(ExposomeSet)}: Transformation of exposures.

}}
\section{Slots}{

\describe{
\item{\code{assayData}}{Contains the exposures matrix with column number equal to
\code{nrow(phenoData)} (see \link{eSet}, \link{AssayData}).}

\item{\code{featureData}}{Contains the description of the exposures including
the family where they belong (see \link{eSet}, \link{AnnotatedDataFrame}).}

\item{\code{phenoData}}{Contains the phenotypes or variables experimenter-supplied
(see \link{eSet}, \link{AnnotatedDataFrame}).}
}}

\seealso{
\code{\link{readExposome}} to create an \code{ExposomeSet}
from files, \code{\link{loadExposome}} to create an \code{ExposomeSet}
from \code{data.frames}
}
