% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation_functions.R
\name{get_original_region_coordinates}
\alias{get_original_region_coordinates}
\title{Retrieves the region stop and start coordinates}
\usage{
get_original_region_coordinates(ribo.object, alias = FALSE)
}
\arguments{
\item{ribo.object}{A 'Ribo' object}

\item{alias}{Option to return the transcript names as aliases}
}
\value{
A data.frame of start and stop coordinates for every region
}
\description{
The function {\code{\link{get_original_region_coordinates}}} retrieves the 
start and site positions for the UTR5, UTR5 Junction, CDS, UTR3 Junction,
and UTR3 regions of every transcript.
}
\details{
To note, because of the R-specific 1-based indexing, the positions start at
1 instead of 0 in other programming languages. The positions provided in 
the returned data.frame will correspond to the positions in the output of 
{\code{\link{get_coverage}}}.

Additionally, within the transcripts, there are edge cases. 
NA values found in the returned data.frame means that the region has no 
start and stop position and a length of zero after computing the boundaries
of the UTR5 and UTR3 junction.
}
\examples{
# generate a ribo object 
file.path <- system.file("extdata", "HEK293_ingolia.ribo", package = "ribor")
sample <- Ribo(file.path, rename = rename_default)

# get the region coordinates
coord <- get_original_region_coordinates(sample, alias = TRUE)

}
