% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metagene_functions.R
\name{plot_metagene}
\alias{plot_metagene}
\title{Plots the metagene coverage data}
\usage{
plot_metagene(
  x,
  site,
  experiment,
  range.lower,
  range.upper,
  normalize = FALSE,
  title = "Metagene Site Coverage",
  tick = 10
)
}
\arguments{
\item{x}{A 'Ribo' object or a data frame generated from \code{\link{get_metagene}}}

\item{site}{"start" or "stop" site}

\item{experiment}{list of experiments}

\item{range.lower}{lower bound of the read length, inclusive}

\item{range.upper}{upper bound of the read length, inclusive}

\item{normalize}{When TRUE, normalizes the data by the total reads.}

\item{title}{title of the generated plot}

\item{tick}{x-axis labeling increment}
}
\value{
A 'ggplot' of the metagene site coverage
}
\description{
The function \code{\link{plot_metagene}} plots the metagene site coverage,
separating by experiment.
}
\details{
If a DataFrame is provided as param 'x', then the only additional parameter
is the optional title' parameter for the generated plot. If a ribo.object is
provided as param 'x', the rest of the parameters listed are necessary.

When given a ribo class object, the \code{\link{plot_metagene}} function
generates a DataFrame by calling the \code{\link{get_tidy_metagene}}
function, so the run times in this case will be mostly comprised of a call
to the \code{\link{get_metagene}} function.

This function uses ggplot in its underlying implementation.
}
\examples{
#a potential use case is to directly pass in the ribo object file as param 'x'

#generate the ribo object to directly use
file.path <- system.file("extdata", "sample.ribo", package = "ribor")
sample <- Ribo(file.path)

#specify experiments of interest
experiments <- c("Hela_1", "Hela_2", "WT_1")

#plot the metagene start site coverage for all experiments in 'sample.ribo'
#from read length 2 to 5
plot_metagene(x = sample,
              site = "start",
              range.lower = 2,
              range.upper = 5,
              experiment = experiments)

#Note that the site, range.lower, range.upper, and experiment parameter are only
#necessary if a ribo object is being passed in as param 'x'. If a ribo
#object is passed in, then the param 'experiments' will be set to all of
#the experiments by default.

#If a DataFrame is passed in, then the plot_metagene function
#does not need any other information. All of the elements of the DataFrame
#will be used, assuming that it contains the same column names and number of
#columns as the output from get_tidy_metagene()

#gets the metagene start site coverage from read length 2 to 5
#note that the data must be summed across transcripts and read lengths
#for the plot_metagene function
data <- get_tidy_metagene(sample,
                          site = "start",
                          range.lower = 2,
                          range.upper = 5)

#plot the metagene data
plot_metagene(data)

}
