% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverageRates.R
\name{coverageRates}
\alias{coverageRates}
\title{Calculate coverage rate}
\usage{
coverageRates(cvgs, RPFsampleOrder, mRNAsampleOrder)
}
\arguments{
\item{cvgs}{Output of \link{coverageDepth}}

\item{RPFsampleOrder, mRNAsampleOrder}{Sample order of RPFs and mRNAs.
The parameters are used to make sure that the order of RPFs and mRNAs
in cvgs is corresponding samples.}
}
\value{
A list with coverage rate.
}
\description{
Coverage is a measure as percentage of position
with reads along the CDS.
Coverage rate calculate coverage rate for RPFs and mRNAs in gene level.
Coverage will be calculated based on best P sites
for RPFs and 5'end for RNA-seq.
}
\examples{
path <- system.file("extdata", package="ribosomeProfilingQC")
RPFs <- dir(path, "RPF.*?\\\\.[12].bam$", full.names=TRUE)
gtf <- file.path(path, "Danio_rerio.GRCz10.91.chr1.gtf.gz")
cvgs <- coverageDepth(RPFs[1], gtf=gtf, level="gene")
cr <- coverageRates(cvgs)
}
