% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryReadsLength.R
\name{summaryReadsLength}
\alias{summaryReadsLength}
\title{Summary the reads lengths}
\usage{
summaryReadsLength(reads, widthRange = c(20:35), plot = TRUE, ...)
}
\arguments{
\item{reads}{Output of getPsiteCoordinates}

\item{widthRange}{The reads range to be plot}

\item{plot}{Do plot or not}

\item{...}{Not use.}
}
\value{
The reads length distribution
}
\description{
Plot the reads length distribution
}
\examples{
reads <- GRanges("chr1", ranges=IRanges(seq.int(100), width=1),
                 qwidth=sample(25:31, size = 100, replace = TRUE,
                               prob = c(.01, .01, .05, .1, .77, .05, .01)))
summaryReadsLength(reads)
}
