% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_GetMinPairwiseCor.R
\name{GetMinPairwiseCor}
\alias{GetMinPairwiseCor}
\title{Calculate minimum pairwise correlation for sub-regions.}
\usage{
GetMinPairwiseCor(
  rnaEditCluster_mat,
  minPairCorr = 0.1,
  probes_ls,
  method = c("spearman", "pearson")
)
}
\arguments{
\item{rnaEditCluster_mat}{A matrix of RNA editing level values on individual 
sites, with row names as sample IDs and column names as site IDs in the 
form of "chrAA:XXXXXXXX".}

\item{minPairCorr}{Minimum pairwise correlation coefficient of sites within 
a cluster, used as a filter. To use this filter, set a number between -1 
and 1 (defaults to 0.1). To turn it off, please set the number to -1.}

\item{probes_ls}{A list of regions with sites. Please note that probes in
each list need to be ordered by their locations.}

\item{method}{Method for computing correlation. Defaults to 
\code{"spearman"}.}
}
\value{
A list with a list of probes passing the minPairCorr and a data 
  frame with the following columns:
  \itemize{
    \item{\code{subregion} : }{index for each output contiguous co-edited
    region.}
    \item{\code{keepminPairwiseCor} : }{indicator for contiguous co-edited
    subregions, The regions with \code{keepminPairwiseCor = 1} passed the
    minimum correlation and will be returned as a contiguous co-edited
    subregion.}
    \item{\code{minPairwiseCor} : }{the minimum pairwise correlation of 
    sites within a subregion.}
  }
}
\description{
Filter the contiguous co-edited subregions found from
  \code{\link{FindCorrelatedRegions}}, by calculating pairwise correlations 
  and then selecting subregions passing the minimum correlation filter.
}
\examples{
  data(t_rnaedit_df)
  
  ordered_cols <- OrderSitesByLocation(
    sites_char = colnames(t_rnaedit_df),
    output = "vector"
  )
  exm_data <- t_rnaedit_df[, ordered_cols]
  
  exm_sites <- list(
    "1" = c("chr1:28661656", "chr1:28661718", "chr1:28662148")
  )
  
  GetMinPairwiseCor(
    rnaEditCluster_mat = exm_data,
    minPairCorr = 0.1,
    probes_ls = exm_sites,
    method = "spearman"
  )
               
}
\keyword{internal}
