% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SummarizeAllRegions.R
\name{SummarizeAllRegions}
\alias{SummarizeAllRegions}
\title{Summarize RNA editing levels from multiple sites in regions.}
\usage{
SummarizeAllRegions(
  regions_gr,
  rnaEditMatrix,
  selectMethod = MedianSites,
  progressBar = "time",
  ...
)
}
\arguments{
\item{regions_gr}{A GRanges object of input genomic regions.}

\item{rnaEditMatrix}{A matrix (or data frame) of RNA editing level values 
for individual sites, with row names as site IDs in the form of
"chrAA:XXXXXXXX", and column names as sample IDs. Please make sure to
follow the format of example dataset (\code{data(rnaedit_df)}).}

\item{selectMethod}{Method for summarizing regions. Available options are 
\code{"MaxSites", "MeanSites", "MedianSites", "PC1Sites"}. Please see
\code{\link{RegionSummaryMethod}} for more details.}

\item{progressBar}{Name of the progress bar to use. There are currently five
types of progress bars: \code{"time"}, \code{"none"}, \code{"text"},
\code{"tk"}, and \code{"win"}. Defaults to \code{"time"}. See
\code{\link[plyr]{create_progress_bar}} for more details.}

\item{...}{Dots for additional internal arguments (currently unused).}
}
\value{
A data frame of the class \code{rnaEdit_df}, includes
  variables \code{seqnames, start, end, width} and summarized RNA editing
  levels in each sample.
}
\description{
A wrapper function to summarize RNA editing levels from 
  multiple sites in regions.
}
\examples{
  data(rnaedit_df)
  
  genes_gr <- TransformToGR(
    genes_char = c("PHACTR4", "CCR5", "METTL7A"),
    type = "symbol",
    genome = "hg19"
  )
  
  exm_regions <- AllCoeditedRegions(
    regions_gr = genes_gr,
    rnaEditMatrix = rnaedit_df,
    output = "GRanges",
    method = "spearman"
  )
  
  SummarizeAllRegions(
    regions_gr = exm_regions,
    rnaEditMatrix = rnaedit_df
  )[1:3, 1:6]

}
\seealso{
\code{\link{TransformToGR}}, \code{\link{AllCloseByRegions}}, 
  \code{\link{AllCoeditedRegions}}, \code{\link{CreateEditingTable}}, 
  \code{\link{TestAssociations}}, \code{\link{AnnotateResults}}
}
