% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/opls-methods.R
\name{getWeightMN}
\alias{getWeightMN}
\alias{getWeightMN,opls-method}
\title{getWeightMN method for (O)PLS(-DA) models}
\usage{
getWeightMN(object, orthoL = FALSE)

\S4method{getWeightMN}{opls}(object, orthoL = FALSE)
}
\arguments{
\item{object}{An S4 object of class \code{opls}, created by \code{opls}
function.}

\item{orthoL}{Logical: Should the orthogonal weight matrix be returned? (default is FALSE)}
}
\value{
Numeric matrix with a number of rows equal to the number of
variables and a number of columns equal to the number of components
}
\description{
(Orthogonal) weights of the (O)PLS(-DA) model
}
\examples{

data(sacurine)
attach(sacurine)

sacurine.plsda <- opls(dataMatrix,
                       sampleMetadata[, "gender"])

getWeightMN(sacurine.plsda)

detach(sacurine)

}
\author{
Etienne Thevenot, \email{etienne.thevenot@cea.fr}
}
