% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saseR-package.R
\docType{package}
\name{saseR-package}
\alias{saseR}
\alias{saseR-package}
\title{saseR: Scalable Aberrant Splicing and Expression Retrieval}
\description{
saseR is a highly performant and fast framework for aberrant expression and splicing analyses. The main functions are: \itemize{ \item \code{\link{BamtoAspliCounts}} - Process BAM files to ASpli counts \item \code{\link{convertASpli}} - Get gene, bin or junction counts from ASpli SummarizedExperiment \item \code{\link{calculateOffsets}} - Create an offsets assays for aberrant expression or splicing analysis \item \code{\link{saseRfindEncodingDim}} - Estimate the optimal number of latent factors to include when estimating the mean expression \item \code{\link{saseRfit}} - Parameter estimation of the negative binomial distribution and compute p-values for aberrant expression and splicing } For information upon how to use these functions, check out our vignette at \url{https://github.com/statOmics/saseR/blob/main/vignettes/Vignette.Rmd} and the saseR paper: Segers, A. et al. (2023). Juggling offsets unlocks RNA-seq tools for fast scalable differential usage, aberrant splicing and expression analyses. bioRxiv. \url{https://doi.org/10.1101/2023.06.29.547014}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/statOmics/saseR}
  \item \doi{10.1101/2023.06.29.547014}
  \item Report bugs at \url{https://github.com/statOmics/saseR/issues}
}

}
\author{
\strong{Maintainer}: Alexandre Segers \email{Alexandre.segers@ugent.be}

Other contributors:
\itemize{
  \item Jeroen Gilis \email{Jeroen.Gilis@ugent.be} [contributor]
  \item Mattias Van Heetvelde \email{Mattias.Vanheetvelde@ugent.be} [contributor]
  \item Elfride De Baere \email{Elfride.Debaere@ugent.be} [contributor]
  \item Lieven Clement \email{Lieven.Clement@ugent.be} [contributor]
}

}
\keyword{internal}
