% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterGB.R
\name{FilterGB}
\alias{FilterGB}
\title{Filter out low count genes and barcodes from count matrix}
\usage{
FilterGB(dat, g_threshold = 0, b_threshold = 0)
}
\arguments{
\item{dat}{Input count matrix to be filtered.}

\item{g_threshold}{Nonnegative integer. Default: \code{0}. Filtering 
threshold for genes. Any gene whose total expression count is less or 
equal to \code{g_threshold} will be filtered out.}

\item{b_threshold}{Nonnegative integer. Default: \code{0}. Filtering 
threshold for barcodes. Any barcode whose total count is less or equal 
to \code{b_threshold} will be filtered out.}
}
\value{
A filtered matrix with the same format as input matrix.
}
\description{
This function is used for filtering out low count genes and barcodes 
from count matrix based on total gene expression count (row sums) and 
barcode expression count (column sums). \code{CB2FindCell}
has already integrated this function into it with \code{g_threshold = 0} 
and \code{b_threshold = 0}. If users plan to customize their filtering 
threshold, this function can be applied to the raw expression
count matrix prior to running \code{CB2FindCell}.
}
\examples{
data(mbrainSub)
dim(mbrainSub)
mbrainSub_f <- FilterGB(mbrainSub)
dim(mbrainSub_f)

}
