% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusKNN.R
\name{clusKNN}
\alias{clusKNN}
\title{A wrapper function for \code{Seurat}'s \code{FindNeighbors} and \code{FindClusters}.}
\usage{
clusKNN(
  indata,
  reducedDim = "UMAP",
  dimColnames = c("UMAP1", "UMAP2"),
  clusterAssignName = "Cluster",
  distance.matrix = FALSE,
  k.param = 20,
  compute.SNN = TRUE,
  prune.SNN = 1/15,
  nn.method = "rann",
  annoy.metric = "euclidean",
  nn.eps = 0,
  verbose = TRUE,
  force.recalc = FALSE,
  modularity.fxn = 1,
  initial.membership = NULL,
  weights = NULL,
  node.sizes = NULL,
  resolution = 0.8,
  method = "matrix",
  algorithm = 1,
  n.start = 10,
  n.iter = 10,
  random.seed = 0,
  group.singletons = TRUE,
  temp.file.location = NULL,
  edge.file.name = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{indata}{A data-frame or matrix, or \code{SingleCellExperiment} object.
If a \code{SingleCellExperiment} object, the cell-to-cluster assignments
will be added as a new column, specified by \code{clusterAssignName}, to
the input object's metadata; if a data-frame or matrix, only the cluster
assignment vector is returned.}

\item{reducedDim}{A reduced dimensional component stored within \code{indata}.
e.g., PCA or UMAP.}

\item{dimColnames}{The column names of the dimensions to use.}

\item{clusterAssignName}{The new column name in the metadata that will
contain the determined cell-to-cluster assignments.}

\item{distance.matrix}{Refer to \code{?Seurat::FindNeighbors}.}

\item{k.param}{Refer to \code{?Seurat::FindNeighbors}.}

\item{compute.SNN}{Refer to \code{?Seurat::FindNeighbors}.}

\item{prune.SNN}{Refer to \code{?Seurat::FindNeighbors}.}

\item{nn.method}{Refer to \code{?Seurat::FindNeighbors}.}

\item{annoy.metric}{Refer to \code{?Seurat::FindNeighbors}.}

\item{nn.eps}{Refer to \code{?Seurat::FindNeighbors}.}

\item{verbose}{Refer to \code{?Seurat::FindNeighbors}.}

\item{force.recalc}{Refer to \code{?Seurat::FindNeighbors}.}

\item{modularity.fxn}{Refer to \code{?Seurat::FindClusters}.}

\item{initial.membership}{Refer to \code{?Seurat::FindClusters}.}

\item{weights}{Refer to \code{?Seurat::FindClusters}.}

\item{node.sizes}{Refer to \code{?Seurat::FindClusters}.}

\item{resolution}{Refer to \code{?Seurat::FindClusters}.}

\item{method}{Refer to \code{?Seurat::FindClusters}.}

\item{algorithm}{Refer to \code{?Seurat::FindClusters}.}

\item{n.start}{Refer to \code{?Seurat::FindClusters}.}

\item{n.iter}{Refer to \code{?Seurat::FindClusters}.}

\item{random.seed}{Refer to \code{?Seurat::FindClusters}.}

\item{group.singletons}{Refer to \code{?Seurat::FindClusters}.}

\item{temp.file.location}{Refer to \code{?Seurat::FindClusters}.}

\item{edge.file.name}{Refer to \code{?Seurat::FindClusters}.}

\item{overwrite}{When the input object is a SingleCellExperiment, enabling
this will result in the overwriting, with the new cluster assignments, of
any column in your metadata that has the same name as
\code{clusterAssignName}.}
}
\value{
A \code{SingleCellExperiment} or \code{numeric} object.
}
\description{
A wrapper function for \code{Seurat}'s \code{FindNeighbors} and \code{FindClusters}.
}
\details{
A wrapper function for Seurat's FindNeighbors and FindClusters.
}
\examples{
# create random data that follows a negative binomial
mat <- jitter(matrix(
  MASS::rnegbin(rexp(1000, rate=.1), theta = 4.5),
  ncol = 20))
colnames(mat) <- paste0('CD', 1:ncol(mat))
rownames(mat) <- paste0('cell', 1:nrow(mat))

clusKNN(mat)

}
\author{
Kevin Blighe <kevin@clinicalbioinformatics.co.uk>
}
