% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataDocumentation.R
\docType{data}
\name{qc_data}
\alias{qc_data}
\title{Quality Control Single-Cell RNA-Seq Dataset}
\format{
An object of class \code{SingleCellExperiment} with 500 rows and 750 columns.
}
\source{
Bunis DG et al. (2021). Single-Cell Mapping of Progressive Fetal-to-Adult Transition in Human Naive T Cells Cell Rep. 34(1): 108573
}
\usage{
qc_data
}
\description{
This dataset contains the processed query dataset from the Bunis haematopoietic stem and progenitor cell data.
It has been preprocessed to include log-normalized counts, QC metrics, SingleR cell type predictions,
and annotation scores.
}
\details{
This dataset underwent the following steps:
\itemize{
  \item Loads the \code{hpca} reference dataset using \code{fetchReference} from the \code{celldex} package.
  \item Loads the QC dataset (Bunis haematopoietic stem and progenitor cell data) from Bunis DG et al. (2021).
  \item Adds QC metrics to the QC dataset using the function \code{addPerCellQCMetrics} from the \code{scuttle} package.
  \item Performs log normalization on the QC dataset using the function \code{logNormCounts} from the \code{scuttle} package.
  \item Runs SingleR to predict cell types and assigns predicted labels to the QC dataset using the function \code{SingleR} from the \code{SingleR} package.
  \item Assigns annotation scores to the QC dataset.
  \item Selects specific columns (\code{total}, \code{SingleR_annotation}, \code{annotation_scores}) from the cell metadata for downstream analysis.
  \item Selects highly variable genes (HVGs) using the function \code{getTopHVGs} from the \code{scran} package on the QC dataset.
}
}
\examples{
# Load and explore the quality control dataset
data("qc_data")

}
\references{
Bunis DG et al. (2021). Single-Cell Mapping of Progressive Fetal-to-Adult Transition in Human Naive T Cells Cell Rep. 34(1): 108573
}
\seealso{
Use \code{data("qc_data")} to load and access the resulting quality control dataset.
}
\keyword{internal}
