% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binning.R
\name{bin_scdata}
\alias{bin_scdata}
\title{Bin genes by mean expression.}
\usage{
bin_scdata(dataset, window_number = NULL, window_size = NULL,
  verbose = TRUE)
}
\arguments{
\item{dataset}{A list, containing the top window generated by \code{extract_top_genes}
as the first element, and the rest of undivided genes as the second. Usually the output
of \code{define_top_genes}}

\item{window_number}{An integer, indicating the number of bins to be used.}

\item{window_size}{An integer, indicating the number of genes to be included
in each window. Ignored if \code{window_size} is defined.}

\item{verbose}{A boolean. Should the function print a message about window size
or the number of windows created?}
}
\value{
A data frame containing the binned genes.
}
\description{
Divides the genes that were not included in the top window in windows of the same size with decreasing
mean expression levels.
}
\details{
Two binning methods are available:

\itemize{
     \item \code{window_number}: Divides the genes into the number of windows specified.

\item \code{window_size}: Divides the genes into windows of the size specified.
}

This function adds a bin number column to the data frame.

This function is designed to take the list output by the
\code{extract_top_window} function as an argument, operating only on the second element
of it. Once the genes in it have been binned, both elements of the list are bound
together in a data frame and returned. The output contains a new column \code{bin},
which indicates the window number assigned to each gene.
}
\examples{
library(magrittr)
expMat <- matrix(
    c(1, 1, 1,
      1, 2, 3,
      0, 1, 2,
      0, 0, 2),
    ncol = 3, byrow = TRUE, dimnames = list(paste("gene", 1:4), paste("cell", 1:3))
)

calculate_cvs(expMat) \%>\%
    define_top_genes(window_size = 1) \%>\%
    bin_scdata(window_number = 2)

calculate_cvs(expMat) \%>\%
    define_top_genes(window_size = 1) \%>\%
    bin_scdata(window_size = 1)

}
