# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Compute Distance between two vectors
#'
#' @param x A numeric vector
#' @param y A numeric vector
#' @return a numeric distance
#' @export
#' @examples
#' x <-matrix(rnbinom(1000,mu=0.01, size=10),nrow=1000)
#' x <- x[1,]
#' y <-matrix(rnbinom(1000,mu=0.01, size=10),nrow=1000)
#' y <- y[1,]
#' distvec(x, y)
#'
distvec <- function(x, y) {
    .Call('_scGPS_distvec', PACKAGE = 'scGPS', x, y)
}

#' Compute Euclidean distance matrix by rows
#'
#' @param x A numeric matrix
#' @return a distance matrix
#' @export
#' @examples
#' mat_test <-matrix(rnbinom(1000,mu=0.01, size=10),nrow=1000)
#' calcDist(mat_test)
#'
calcDist <- function(x) {
    .Call('_scGPS_calcDist', PACKAGE = 'scGPS', x)
}

#' Compute Euclidean distance matrix by rows
#'
#' @param x A numeric matrix
#' @return a distance matrix
#' @export
#' @examples
#' mat_test <-matrix(rnbinom(1000,mu=0.01, size=10),nrow=1000)
#' #library(microbenchmark)
#' #microbenchmark(calcDistArma(mat_test), dist(mat_test), times=3)
#'
#'
calcDistArma <- function(x) {
    .Call('_scGPS_calcDistArma', PACKAGE = 'scGPS', x)
}

#' distance matrix using C++
#'
#' @description This function provides fast and memory efficient distance matrix
#' calculation
#' @param mat an R matrix (expression matrix), rows are genes, columns are cells
#' @return a distance matrix
#' @export
#' @examples
#' mat_test <-matrix(rnbinom(1000000,mu=0.01, size=10),nrow=10000)
#' #library(microbenchmark)
#' #microbenchmark(rcpp_parallel_distance(mat_test), dist(mat_test), times=3)
#'
rcpp_parallel_distance <- function(mat) {
    .Call('_scGPS_rcpp_parallel_distance', PACKAGE = 'scGPS', mat)
}

#' Function to calculate Eucledean distance matrix without parallelisation
#'
#' @param mat an R matrix (expression matrix), with cells in rows and genes
#' in columns
#' @return a distance matrix
#' @export
#' @examples
#' mat_test <-matrix(rnbinom(100000,mu=0.01, size=10),nrow=1000)
#' #library(microbenchmark)
#' #microbenchmark(rcpp_Eucl_distance_NotPar(mat_test), dist(mat_test), times=3)
#'
rcpp_Eucl_distance_NotPar <- function(mat) {
    .Call('_scGPS_rcpp_Eucl_distance_NotPar', PACKAGE = 'scGPS', mat)
}

#' Calculate mean
#'
#' @param x integer.
#' @return a scalar value
#' @export
#' @examples
#' mean_cpp(seq_len(10^6))
#'
mean_cpp <- function(x) {
    .Call('_scGPS_mean_cpp', PACKAGE = 'scGPS', x)
}

#' Calculate variance
#'
#' @param x a vector of gene expression.
#' @param bias degree of freedom
#' @return a variance value
#' @export
#' @examples
#'var_cpp(seq_len(10^6))
#'
var_cpp <- function(x, bias = TRUE) {
    .Call('_scGPS_var_cpp', PACKAGE = 'scGPS', x, bias)
}

#' Transpose a matrix
#'
#' @param X  an R matrix (expression matrix)
#' @return a transposed matrix
#' @export
#' @examples
#' mat_test <-matrix(rnbinom(1000000,mu=0.01, size=10),nrow=100)
#' tp_mat <- tp_cpp(mat_test)
tp_cpp <- function(X) {
    .Call('_scGPS_tp_cpp', PACKAGE = 'scGPS', X)
}

#' Subset a matrix
#'
#' @param m1in an R matrix (expression matrix)
#' @param rowidx_in a numeric vector of rows to keep
#' @param colidx_in a numeric vector of columns to keep
#' @return a subsetted matrix
#' @export
#' @examples
#' mat_test <-matrix(rnbinom(1000000,mu=0.01, size=10),nrow=100)
#' subset_mat <- subset_cpp(mat_test, rowidx_in=c(1:10), colidx_in=c(100:500))
#' dim(subset_mat)
subset_cpp <- function(m1in, rowidx_in, colidx_in) {
    .Call('_scGPS_subset_cpp', PACKAGE = 'scGPS', m1in, rowidx_in, colidx_in)
}

#' Principal component analysis
#'
#' @description This function provides significant speed gain if the input
#' matrix is big
#' @param X  an R matrix (expression matrix), rows are genes, columns are cells
#' @return a list with three list pca lists
#' @export
#' @examples
#' mat_test <-matrix(rnbinom(1000000,mu=0.01, size=10),nrow=1000)
#' #library(microbenchmark)
#' #microbenchmark(PrinComp_cpp(mat_test), prcomp(mat_test), times=3)
#'
PrinComp_cpp <- function(X) {
    .Call('_scGPS_PrinComp_cpp', PACKAGE = 'scGPS', X)
}

