% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CORE_clustering.R
\name{rand_index}
\alias{rand_index}
\title{Calculate rand index}
\usage{
rand_index(tab, adjust = TRUE)
}
\arguments{
\item{tab}{a table containing different clustering results in rows}

\item{adjust}{a logical of whether to use the adjusted rand index}
}
\value{
a rand_index value
}
\description{
Comparing clustering results Function for calculating randindex
(adapted from the function by Steve Horvath and Luohua Jiang, UCLA, 2003)
}
\examples{
day5 <- day_5_cardio_cell_sample
mixedpop2 <-new_summarized_scGPS_object(ExpressionMatrix = day5$dat5_counts,
GeneMetadata = day5$dat5geneInfo, CellMetadata = day5$dat5_clusters)
cluster_all <-clustering(object=mixedpop2)

rand_index(table(unlist(cluster_all$list_clusters[[1]]), 
cluster_all$cluster_ref))

}
\author{
Quan Nguyen and Michael Thompson, 2018-05-11
}
