% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{scHOT_buildFromSCE}
\alias{scHOT_buildFromSCE}
\title{scHOT_buildFromSCE}
\usage{
scHOT_buildFromSCE(
  sce,
  assayName = "counts",
  positionType = NULL,
  positionColData = NULL
)
}
\arguments{
\item{sce}{A SingleCellExperiment object}

\item{assayName}{is a single assay to pull out from sce as
the expression matrix input of scHOT}

\item{positionType}{A string indicates the position type,
either trajectory or spatial}

\item{positionColData}{Strings indicate the position information
stored in colData.
If positionType is "trajectory" then positionColData
should be a sortable vector
if positionType is "spatial" then positionColData
should be a matrix type object.}
}
\value{
A scHOT object
}
\description{
Create scHOT object from a SingleCellExperiment object
}
\examples{

library(SingleCellExperiment)
dat <- rbind(rnorm(50), rnorm(50), rnorm(50))
colnames(dat) <- paste0("cell_", 1:ncol(dat))
rownames(dat) <- c("gene_1","gene_2", "gene_2")

sce <- SingleCellExperiment::SingleCellExperiment(assays =
S4Vectors::SimpleList(counts = dat))
scHOT <- scHOT_buildFromSCE(sce)

}
