% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ruvSimulate.R
\name{ruvSimulate}
\alias{ruvSimulate}
\title{Simulate a simple matrix or SingleCellExperiment to test internals of scMerge}
\usage{
ruvSimulate(
  m = 100,
  n = 5000,
  nc = floor(n/2),
  nCelltypes = 3,
  nBatch = 2,
  k = 20,
  lambda = 0.1,
  sce = FALSE
)
}
\arguments{
\item{m}{Number of observations}

\item{n}{Number of features}

\item{nc}{Number of negative controls}

\item{nCelltypes}{Number of cell-types}

\item{nBatch}{Number of batches}

\item{k}{Number of unwanted factors in simulation}

\item{lambda}{Rate parameter for random Poisson generation}

\item{sce}{If \code{TRUE}, returns a SingleCellExperiment object}
}
\value{
If \code{sce} is FALSE, then the output is a list consists of
\itemize{
\item Y,  expression matrix generated through Poisson random variables,
\item ctl, a logical vector indicating the control genes,
\item M, replicate mapping matrix,
\item cellTypes, a vector indicating simulated cell types
\item batch, a vector indicating simulated batches
}
if \code{sce} is TRUE, a SingleCellExperiment wrapper will be applied on all above simulated objects.
}
\description{
This function is designed to generate Poisson-random-variable data matrix
to test on the internal algorithms of scMerge. 
It does not represent real biological situations 
and it is not intended to be used by end-users.
}
\examples{
set.seed(1)
L = ruvSimulate(m = 200, n = 1000, nc = 200, 
nCelltypes = 3, nBatch = 2, lambda = 0.1, k = 10, sce = TRUE)
print(L)
example <- scMerge(sce_combine = L,
                      ctl = paste0('gene', 1:500),
                      cell_type = L$cellTypes,
                      ruvK = 10,
                      assay_name = 'scMerge')
L = scater::runPCA(L, exprs_values = "logcounts")                      
scater::plotPCA(L, colour_by = 'cellTypes', shape = 'batch')

example = scater::runPCA(example, exprs_values = 'scMerge')                                       
scater::plotPCA(example, colour_by = 'cellTypes', shape = 'batch')
}
