% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{format.mtmutObj}
\alias{format.mtmutObj}
\alias{print.mtmutObj}
\alias{is.mtmutObj}
\title{Print mtmutObj object}
\usage{
\method{format}{mtmutObj}(x, ...)

\method{print}{mtmutObj}(x, ...)

is.mtmutObj(x)
}
\arguments{
\item{x}{a mtmutObj object.}

\item{...}{other parameters passed to \code{\link[base]{format}} or \code{\link[base]{print}}.}
}
\value{
a string
}
\description{
The print method for mtmutObj object.
}
\examples{
## Use the example data
f <- system.file("extdata", "mini_dataset.tsv.gz", package = "scMitoMut")
## Create a temporary h5 file
## In real case, we keep the h5 in project folder for future use
f_h5_tmp <- tempfile(fileext = ".h5")
## Load the data with parse_table function
f_h5 <- parse_table(f, sep = "\t", h5_file = f_h5_tmp)
f_h5
## open the h5 file and create a mtmutObj object
x <- open_h5_file(f_h5)
x
print(x)
}
