% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/SCE_methods.R
\docType{methods}
\name{UMI_dup_info}
\alias{UMI_dup_info}
\alias{UMI_dup_info<-}
\alias{UMI_dup_info.sce}
\alias{UMI_dup_info,SingleCellExperiment-method}
\alias{UMI_dup_info<-,SingleCellExperiment-method}
\title{Get or set UMI duplication results in a SingleCellExperiment object}
\usage{
UMI_dup_info(object)

UMI_dup_info(object) <- value

UMI_dup_info.sce(object)

\S4method{UMI_dup_info}{SingleCellExperiment}(object)

\S4method{UMI_dup_info}{SingleCellExperiment}(object) <- value
}
\arguments{
\item{object}{A \code{\link{SingleCellExperiment}} object.}

\item{value}{Value to be assigned to corresponding object.}
}
\value{
a dataframe of cell UMI duplication information

A DataFrame of UMI duplication results.
}
\description{
Get or set UMI duplication results in a SingleCellExperiment object
}
\examples{
data("sc_sample_data")
data("sc_sample_qc")
sce = SingleCellExperiment(assays = list(counts = as.matrix(sc_sample_data)))
organism(sce) = "mmusculus_gene_ensembl"
gene_id_type(sce) = "ensembl_gene_id"
QC_metrics(sce) = sc_sample_qc
demultiplex_info(sce) = cell_barcode_matching
UMI_dup_info(sce) = UMI_duplication

head(UMI_dup_info(sce))

}
\author{
Luyi Tian
}
