% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc_atac_bam_tagging.R
\name{sc_atac_bam_tagging}
\alias{sc_atac_bam_tagging}
\title{BAM tagging}
\usage{
sc_atac_bam_tagging(
  inbam,
  output_folder = NULL,
  bc_length = NULL,
  bam_tags = list(bc = "CB", mb = "OX"),
  nthreads = 1
)
}
\arguments{
\item{inbam}{The input BAM file}

\item{output_folder}{The path of the output folder}

\item{bc_length}{The length of the cellular barcodes}

\item{bam_tags}{The BAM tags}

\item{nthreads}{The number of threads}
}
\value{
file path of the resultant demmultiplexed BAM file.
}
\description{
Demultiplexes the reads
}
\details{
sc_atac_bam_tagging()
}
\examples{
r1 <- system.file("extdata", "small_chr21_R1.fastq.gz", package="scPipe")
r2 <- system.file("extdata", "small_chr21_R3.fastq.gz", package="scPipe")
barcode_fastq <- system.file("extdata", "small_chr21_R2.fastq.gz", package="scPipe")
out <- tempdir()

sc_atac_trim_barcode(r1=r1, r2=r2, bc_file=barcode_fastq, output_folder=out)

demux_r1 <- file.path(out, "demux_completematch_small_chr21_R1.fastq.gz")
demux_r2 <- file.path(out, "demux_completematch_small_chr21_R3.fastq.gz")
reference <- system.file("extdata", "small_chr21.fa", package="scPipe")

aligned_bam <- sc_aligning(ref=reference, R1=demux_r1, R2=demux_r2, nthreads=6, output_folder=out)

out_bam <- sc_atac_bam_tagging(
   inbam = aligned_bam,
   output_folder = out,
   nthreads = 6)

}
