% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTranscriptSequence.R
\name{getTranscriptSequence}
\alias{getTranscriptSequence}
\title{getTranscriptSequence}
\usage{
getTranscriptSequence(
  tx = NULL,
  annotation,
  annoFilter = NULL,
  extract = c("UTRonly", "withORF", "exons"),
  ...
)
}
\arguments{
\item{tx}{The ensembl ID of the transcript(s)}

\item{annotation}{A \code{\link{ScanMiRAnno}} object.}

\item{annoFilter}{An optional `AnnotationFilter` or `AnnotationFilterList` to
further filter the set of transcripts to be extracted}

\item{extract}{Which parts of the transcripts to extract. For `UTRonly`
(default) only the 3' UTR regions are extracted, `withORF` additionally
extracts the coding regions, and `exons` extracts all exons}

\item{...}{Passed to \code{\link{AnnotationHub}}}
}
\value{
A \code{\link{DNAStringSet}}.
}
\description{
Utility wrapper to extracts the sequence of a given transcript (UTR or
CDS+UTR).
}
\examples{
anno <- ScanMiRAnno("fake")
seq <- getTranscriptSequence( tx="ENSTFAKE0000056456", annotation=anno )
}
