% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sccomp_proportional_fold_change.R
\name{sccomp_proportional_fold_change}
\alias{sccomp_proportional_fold_change}
\title{Calculate Proportional Fold Change from sccomp Estimated Effects}
\usage{
sccomp_proportional_fold_change(.data, formula_composition, from, to)
}
\arguments{
\item{.data}{A sccomp estimate object (of class 'sccomp_tbl') obtained from running sccomp_estimate().
This object contains the fitted model and estimated effects.}

\item{formula_composition}{The formula specifying which model effects to use for calculating fold changes.
This should match or be a subset of the formula used in the original sccomp_estimate() call.}

\item{from}{Character string specifying the reference/control condition (e.g., "benign").}

\item{to}{Character string specifying the comparison condition (e.g., "cancer").}
}
\value{
A tibble with the following columns:
\itemize{
\item cell_group - The cell group identifier
\item proportion_fold_change - The estimated fold change in proportions between conditions.
Positive values indicate increases, negative values indicate decreases.
\item average_uncertainty - The average uncertainty in the fold change estimate, derived from the credible intervals
\item statement - A text description of the fold change, including the direction and the estimated proportions
}
}
\description{
This function calculates the proportional fold change between two conditions using the estimated effects from a sccomp model.
The fold changes are derived from the model's posterior predictions rather than raw counts, providing a more robust estimate
that accounts for the model's uncertainty and covariate effects.

Note! This statistic is descriptive and should not be used to define significance - use sccomp_test() for that.
While fold changes in proportions are easier to interpret than changes in logit space, they are not linear
(the same proportional change has different meaning for rare vs abundant cell types). In contrast,
the logit scale used internally by sccomp provides linear effects that are more appropriate for statistical inference.
}
\examples{

print("cmdstanr is needed to run this example.")
# Note: Before running the example, ensure that the 'cmdstanr' package is installed:
# install.packages("cmdstanr", repos = c("https://stan-dev.r-universe.dev/", getOption("repos")))


\donttest{
if (instantiate::stan_cmdstan_exists()) {
  # Load example data
  data("counts_obj")

  # First estimate the composition effects
  estimate <- sccomp_estimate(
      counts_obj,
      ~ type,
      ~1,
      "sample",
      "cell_group",
      "count",
      cores = 1
  )
 
  # Calculate proportional fold changes from the estimated effects
  estimate |> 
  sccomp_proportional_fold_change(
    formula_composition = ~  type, 
    from = "benign", 
    to = "cancer"
  ) 
}
}
}
