% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_calls.R
\name{get_dblCalls_ROC}
\alias{get_dblCalls_ROC}
\title{Derive doublet calls from classification probabilities}
\usage{
get_dblCalls_ROC(scrs_real, scrs_sim, rel_loss = 1)
}
\arguments{
\item{scrs_real}{numeric vector, the scores for the real/original data}

\item{scrs_sim}{numeric vector, the scores for the artificial doublets}

\item{rel_loss}{numeric scalar, relative weight of a false positive classification compared with a false negative. Default:1 (same loss for fp and fn).}
}
\value{
numeric, vector containing the (estimated) number of doublets, the score threshold and the fraction of artificial doublets missed (false negative rate, of sorts)
}
\description{
Given class probabilities (or scores) discriminating real data from artificial doublets, derive doublet calls. Based on selecting a ROC cutoff, see \emph{The Inconsistency of ‘‘Optimal’’ Cutpoints Obtained using Two Criteria basedon the Receiver Operating Characteristic Curve}, \href{https://dx.doi.org/10.1093/aje/kwj063}{(doi)}.
}
