% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/featureCoverage.R
\name{featureCoverage}
\alias{featureCoverage}
\title{Coverage based on the genomic feature}
\usage{
featureCoverage(bs, features, genomebuild)
}
\arguments{
\item{bs}{bsseq object}

\item{features}{list of genomic features, e.g. genes_exons, genes_introns,
cpg_islands, cpg_shelves
Names are based on the annotatr packages, so all the features provided by the
annotatr
package will be supported in this function}

\item{genomebuild}{reference alignment, i.e. mm10 or hg38}
}
\value{
a data frame with genomic feature names and the number of
CpG covered in each feature
}
\description{
Provides Coverage metrics for the sample by each genomic features provided
by the user
}
\examples{
directory <- system.file("extdata/bismark_data", package='scmeth')
bs <- HDF5Array::loadHDF5SummarizedExperiment(directory)
featureCoverage(bs, c('cpg_islands', 'cpg_shores'), 'hg38')
}
