% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_fetch_signal.R
\name{prepare_fetch_GRanges_width}
\alias{prepare_fetch_GRanges_width}
\title{prepares GRanges for windowed fetching.}
\usage{
prepare_fetch_GRanges_width(
  qgr,
  win_size,
  min_quantile = 0.75,
  target_size = NULL,
  skip_centerFix = FALSE
)
}
\arguments{
\item{qgr}{GRanges to prepare}

\item{win_size}{numeric window size for fetch}

\item{min_quantile}{numeric value from 0 to 1. Lowest possible quantile value.  Only
relevant if target_size is not specified.}

\item{target_size}{numeric final width of qgr if known. Default of NULL
leads to quantile based determination of target_size.}

\item{skip_centerFix}{boolean, if FALSE (default) all regions will be resized
GenomicRanges::resize(x, w, fix = "center") to a uniform size based on
min_quantile to a width divisible by win_size.}
}
\value{
GRanges, either identical to qgr or with suitable consistent width
applied.
}
\description{
output GRanges parallels input with consistent width evenly divisible by
win_size.  Has warning if GRanges needed resizing, otherwise no warning
and input GRanges is returned unchanged.
}
\examples{
data(CTCF_in_10a_overlaps_gr)
qgr = prepare_fetch_GRanges_width(CTCF_in_10a_overlaps_gr, win_size = 50)
#no warning if qgr is already valid for windowed fetching
prepare_fetch_GRanges_width(qgr, win_size = 50)
}
