% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-misc.R
\name{upload_info_part}
\alias{upload_info_part}
\title{Returns AWS S3 signed URL for a part of the file upload}
\usage{
upload_info_part(token = NULL, upload_id = NULL, part_number = NULL, ...)
}
\arguments{
\item{token}{auth token}

\item{upload_id}{ID of the upload}

\item{part_number}{Number of the upload file part that you wish to access}

\item{...}{parameters passed to api function}
}
\value{
parsed list of the returned json
}
\description{
Gets the signed URL for the upload of the specified part.
Note that URLs are valid for 60 seconds only and that you should initiate
upload to the signed URL in this time frame.
}
\examples{
token <- "your_token"
\dontrun{
req <- upload_info_part(token, upload_id = "your_upload_id", part_number = 1)}
}
