% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gess_lincs.R
\name{rand_query_ES}
\alias{rand_query_ES}
\title{Generate WTCS Null Distribution with Random Queries}
\usage{
rand_query_ES(h5file, N_queries = 1000, dest, write = TRUE)
}
\arguments{
\item{h5file}{character(1), path to the HDF5 file representing the
reference database}

\item{N_queries}{number of random queries}

\item{dest}{path to the output file (e.g. "ES_NULL.txt")}

\item{write}{Logical value indicating if results should be written to dest.}
}
\value{
File with path assigned to \code{dest}
}
\description{
Function computes null distribution of Weighted Connectivity Scores (WTCS)
used by the LINCS GESS method for computing nominal P-values.
}
\examples{
db_path = system.file("extdata", "sample_db.h5", package="signatureSearch")
rand <- rand_query_ES(h5file=db_path, N_queries=5, dest="ES_NULL.txt", write=FALSE)
unlink("ES_NULL.txt")
}
\references{
Subramanian, A., Narayan, R., Corsello, S. M., Peck, D. D., Natoli, T. E.,
Lu, X., Golub, T. R. (2017). A Next Generation Connectivity Map: L1000
Platform and the First 1,000,000 Profiles. Cell, 171 (6), 1437-1452.e17.
URL: https://doi.org/10.1016/j.cell.2017.10.049
}
\seealso{
\code{\link{gess_lincs}}
}
