% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructor.R
\name{mcols,ontology_DAG-method}
\alias{mcols,ontology_DAG-method}
\alias{mcols<-,ontology_DAG-method}
\title{Get or set meta columns on DAG}
\usage{
\S4method{mcols}{ontology_DAG}(x, use.names = TRUE, ...)

\S4method{mcols}{ontology_DAG}(x, ...) <- value
}
\arguments{
\item{x}{An \code{ontology_DAG} object.}

\item{use.names}{Please ignore.}

\item{...}{Other argument. For \code{mcols()}, it can be a vector of column names in the meta data frame.}

\item{value}{A data frame or a matrix where rows should correspond to terms in \code{x@terms}.}
}
\value{
A data frame.
}
\description{
Get or set meta columns on DAG
}
\examples{
parents  = c("a", "a", "b", "b", "c", "d")
children = c("b", "c", "c", "d", "e", "f")
dag = create_ontology_DAG(parents, children)
mcols(dag) = data.frame(id = letters[1:6], v = 1:6)
mcols(dag)
mcols(dag, "id")
dag
}
