% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scds_doubletdetection.R
\name{runCxdsBcdsHybrid}
\alias{runCxdsBcdsHybrid}
\title{Find doublets/multiplets using \link[scds]{cxds_bcds_hybrid}.}
\usage{
runCxdsBcdsHybrid(
  inSCE,
  sample = NULL,
  seed = 12345,
  nTop = 500,
  cxdsArgs = list(),
  bcdsArgs = list(),
  verb = FALSE,
  estNdbl = FALSE,
  force = FALSE,
  useAssay = "counts"
)
}
\arguments{
\item{inSCE}{A \link[SingleCellExperiment]{SingleCellExperiment} object.
Needs \code{counts} in assays slot.}

\item{sample}{Character vector. Indicates which sample each cell belongs to.
\link[scds]{cxds_bcds_hybrid} will be run on cells from each sample
separately. If NULL, then all cells will be processed together.
Default NULL.}

\item{seed}{Seed for the random number generator. Default 12345.}

\item{nTop}{The number of top varialbe genes to consider. Used in both \code{csds}
and \code{bcds}. Default \code{500}.}

\item{cxdsArgs}{See \link[scds]{cxds_bcds_hybrid} for more information. Default \code{NULL}.}

\item{bcdsArgs}{See \link[scds]{cxds_bcds_hybrid} for more information. Default \code{NULL}.}

\item{verb}{See \link[scds]{cxds_bcds_hybrid} for more information. Default \code{FALSE}.}

\item{estNdbl}{See \link[scds]{cxds_bcds_hybrid} for more information. Default \code{FALSE}.}

\item{force}{See \link[scds]{cxds_bcds_hybrid} for more information. Default \code{FALSE}.}

\item{useAssay}{A string specifying which assay in the SCE to use.}
}
\value{
A \link[SingleCellExperiment]{SingleCellExperiment} object with
 \link[scds]{cxds_bcds_hybrid} output appended to the
 \link{colData} slot. The columns include
 \emph{hybrid_score} and optionally \emph{hybrid_call}.
 Please refer to the documentation of \link[scds]{cxds_bcds_hybrid} for
 details.
}
\description{
A wrapper function for \link[scds]{cxds_bcds_hybrid}. Annotate
 doublets/multiplets using a binary classification approach to discriminate
 artificial doublets from original data. Generate a doublet
 score for each cell. Infer doublets if \code{estNdbl} is \code{TRUE}.
}
\examples{
data(scExample, package = "singleCellTK")
sce <- subsetSCECols(sce, colData = "type != 'EmptyDroplet'")
sce <- runCxdsBcdsHybrid(sce)
}
