% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allSitesName.R
\name{allSitesName}
\alias{allSitesName}
\alias{allSitesName.SNPsites}
\alias{allSitesName.sitesMinEntropy}
\alias{allSitesName.fixationSites}
\alias{allSitesName.parallelSites}
\alias{allSitesName.paraFixSites}
\title{Retrieve position of all the sites}
\usage{
allSitesName(x, ...)

\method{allSitesName}{SNPsites}(x, ...)

\method{allSitesName}{sitesMinEntropy}(x, ...)

\method{allSitesName}{fixationSites}(x, ...)

\method{allSitesName}{parallelSites}(x, ...)

\method{allSitesName}{paraFixSites}(x, type = c("paraFix", "fixation", "parallel"), ...)
}
\arguments{
\item{x}{The object containing the sites from analysis}

\item{...}{Other arguments}

\item{type}{Return fixation or parallel sites}
}
\value{
An integer vector for sites position
}
\description{
The function is a way to get position of the resulting sites
  from \code{\link{SNPsites}}, \code{\link{fixationSites}} and
  \code{\link{parallelSites}}. The numbering is consistent with what's being
  set by \code{\link{setSiteNumbering}}
}
\examples{
data(zikv_tree)
msaPath <- system.file('extdata', 'ZIKV.fasta', package = 'sitePath')
tree <- addMSA(zikv_tree, msaPath = msaPath, msaFormat = 'fasta')
snp <- SNPsites(tree)
allSitesName(snp)
}
